/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.ColorFilter;
import components.MapTransform;
import components.StaticText;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.FilteredImageSource;
import java.util.Hashtable;

public class MapView
implements Runnable {
    private boolean mapError;
    private boolean mapLoaded;
    private Image filteredImg;
    private Image originalImg;
    private Image blankImg;
    private String mapName;
    private Applet applet;
    private MediaTracker tracker;
    private int imgWidth;
    private int imgHeight;
    private Hashtable mapCache;
    private static int trackId = 0;
    private MapTransform mtr;
    private double zoom;
    private int rot;
    private int x;
    private int y;
    private StaticText error;

    public MapView(Applet apt, StaticText e) {
        this.applet = apt;
        this.tracker = new MediaTracker(this.applet);
        this.blankImg = this.applet.createImage(this.applet.getWidth(), this.applet.getHeight());
        this.mapCache = new Hashtable();
        this.mapName = "";
        this.error = e;
    }

    public void setMap(String m, double z, int r, int px, int py) {
        if (m.equals("")) {
            return;
        }
        String string = this.mapName;
        synchronized (string) {
            this.zoom = z;
            this.rot = r;
            this.x = px;
            this.y = py;
            this.mapName = m;
            Object element = this.mapCache.get(this.mapName);
            if (element == null) {
                this.mapError = false;
                this.mapLoaded = false;
                this.error.setText("Please wait...");
                this.originalImg = this.applet.getImage(this.applet.getDocumentBase(), "overviews/" + this.mapName + ".png");
                this.tracker.addImage(this.originalImg, trackId);
                new Thread(this).start();
            } else {
                this.error.setText("");
                this.mtr = new MapTransform(this.imgWidth, this.imgHeight, this.x, this.y, this.zoom, this.rot);
                this.mapError = false;
                this.mapLoaded = true;
                this.filteredImg = (Image)element;
            }
        }
    }

    public Point getOrigin(int x, int y) {
        if (this.mtr != null) {
            return this.mtr.getOrigin(x, y);
        }
        return new Point(0, 0);
    }

    public int getAngle(int aaa) {
        return this.mtr.getAngle(aaa);
    }

    public final boolean isMapAvailable() {
        return !this.mapError && this.mapLoaded;
    }

    public final boolean isError() {
        return this.mapError;
    }

    public void draw(Graphics g, long time) {
        if (this.isMapAvailable()) {
            g.drawImage(this.filteredImg, 0, 0, this.applet);
        } else {
            g.drawImage(this.blankImg, 0, 0, null);
        }
    }

    public final int getHeight() {
        return this.imgHeight;
    }

    public final int getWidth() {
        return this.imgWidth;
    }

    public void run() {
        String string = this.mapName;
        synchronized (string) {
            try {
                this.tracker.waitForID(trackId);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mapError = this.tracker.isErrorID(trackId);
            ++trackId;
            if (!this.mapError) {
                ColorFilter colorfilter = new ColorFilter(Color.green, this.applet.getBackground());
                this.filteredImg = this.applet.createImage(new FilteredImageSource(this.originalImg.getSource(), colorfilter));
                this.imgWidth = this.originalImg.getWidth(this.applet);
                this.imgHeight = this.originalImg.getHeight(this.applet);
                this.mapCache.put(this.mapName, this.filteredImg);
                this.mtr = new MapTransform(this.imgWidth, this.imgHeight, this.x, this.y, this.zoom, this.rot);
                this.error.setText("");
                this.mapLoaded = true;
            } else {
                this.error.setText("Sorry, but the overview for " + this.mapName + " is unavailable...");
            }
        }
    }
}

