// NIGHTCRAWLER!

/* CVARS - copy and paste to shconfig.cfg

//Night Crawler
nightc_level 0
nightc_cooldown 30			//# of seconds before NightCrawler can NoClip Again
nightc_cliptime 6			//# of seconds NightCrawler has in noclip mode.

*/

#include <amxmod>
#include <Vexd_Utilities>
#include <superheromod>

// GLOBAL VARIABLES
new gHeroName[]="NightCrawler"
new bool:gHasNightCPower[SH_MAXSLOTS+1]
new g_nightCrawlerTimer[SH_MAXSLOTS+1]
new g_lastPosition[SH_MAXSLOTS+1][3]   // Variable to help with position checking
new g_nightCrawlerSound[]="ambience/alien_zonerator.wav"
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Nightcrawler","1.18","{HOJ} Batman")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("nightc_level", "0" )
	register_cvar("nightc_cooldown", "30" )
	register_cvar("nightc_cliptime", "6" )

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Walk Through Walls", "Can Walk Through Walls for Short Time - GET STUCK AND YOU'LL BE AUTO-SLAIN!", true, "nightc_level")

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)
	register_event("ResetHUD","newRound","b")

	// KEY DOWN
	register_srvcmd("nightc_kd", "nightc_kd")
	shRegKeyDown(gHeroName, "nightc_kd")

	// INIT
	register_srvcmd("nightc_init", "nightc_init")
	shRegHeroInit(gHeroName, "nightc_init")

	// LOOP
	set_task(1.0,"nightc_loop",0,"",0,"b" )

	// DEATH
	register_event("DeathMsg", "nightc_death", "a")
}
//----------------------------------------------------------------------------------------------
public plugin_precache()
{
	// TBD - May want to do Ludwigs scotty teleport graphics later for this...
	precache_sound(g_nightCrawlerSound)
}
//----------------------------------------------------------------------------------------------
public nightc_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has iron man powers
	read_argv(2,temp,5)
	new hasPowers = str_to_num(temp)

	gHasNightCPower[id] = (hasPowers != 0)

	if ( !hasPowers ) {
		if ( g_nightCrawlerTimer[id] >= 0 ) {
			nightc_endnoclip(id)
		}
	}
	else {
		// Make sure looop doesn't fire for them
		g_nightCrawlerTimer[id] = -1
	}
}
//----------------------------------------------------------------------------------------------
public newRound(id)
{
	gPlayerUltimateUsed[id] = false
	g_nightCrawlerTimer[id]= -1
	if (gHasNightCPower[id]) {
		nightc_endnoclip(id)
	}
}
//----------------------------------------------------------------------------------------------
// RESPOND TO KEYDOWN
public nightc_kd()
{
	if ( !hasRoundStarted() ) return PLUGIN_HANDLED

	// First Argument is an id with NightCrawler Powers!
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	if ( !is_user_alive(id) ) return PLUGIN_HANDLED

	// Make sure they're not in the middle of clip already
	// Let them know they already used their ultimate if they have
	if ( gPlayerUltimateUsed[id] || g_nightCrawlerTimer[id] > 0 ) {
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}

	//If the user already has noclip (prob from another hero) cancel this keydown
	if (get_user_noclip(id) == 1) {
		client_print(id,print_chat,"[SH](NightCrawler) You are already using noclip")
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}

	g_nightCrawlerTimer[id] = get_cvar_num("nightc_cliptime")
	set_user_noclip(id,1)
	ultimateTimer(id, get_cvar_num("nightc_cooldown") * 1.0)

	// NightCrawler Messsage
	new message[128]
	format(message, 127, "Entered NightCrawler Mode^nDon't get Stuck or you will die" )
	set_hudmessage(255,0,0,-1.0,0.3,0,0.25,1.2,0.0,0.0,87)
	show_hudmessage(id, message)
	emit_sound(id,CHAN_STATIC, g_nightCrawlerSound, 0.2, ATTN_NORM, 0, PITCH_LOW)

	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
public stopSound(id)
{
	new SND_STOP=(1<<5)
	emit_sound(id,CHAN_STATIC, g_nightCrawlerSound, 0.0, ATTN_NORM, SND_STOP, PITCH_LOW)
}
//----------------------------------------------------------------------------------------------
public nightc_loop()
{
	for ( new id = 1; id <= SH_MAXSLOTS; id++ ) {
		if ( gHasNightCPower[id] && is_user_alive(id)  )  {
			if ( g_nightCrawlerTimer[id] > 0 ) {
				new message[128]
				format(message, 127, "%d seconds left of NightCrawler Mode^nDon't get Stuck or you will die", g_nightCrawlerTimer[id] )
				set_hudmessage(255,0,0,-1.0,0.3,0,1.0,1.2,0.0,0.0,87)
				show_hudmessage( id, message)
				g_nightCrawlerTimer[id]--
			}
			else if ( g_nightCrawlerTimer[id] == 0 ) {
				g_nightCrawlerTimer[id]--
				nightc_endnoclip(id)
			}
		}
	}
}
//----------------------------------------------------------------------------------------------
public nightc_endnoclip(id)
{
	if (!is_user_connected(id)) return
	g_nightCrawlerTimer[id] = -1
	stopSound(id)

	if (!is_user_alive(id)) return
	if ( get_user_noclip(id) == 1) {
		// Turn off no-clipping and make sure the user has moved
		set_user_noclip(id, 0)
		positionChangeTimer(id)
	}
}
//----------------------------------------------------------------------------------------------
public nightc_death()
{
	new id = read_data(2)
	gPlayerUltimateUsed[id] = false
	g_nightCrawlerTimer[id]= -1
	if (gHasNightCPower[id]) {
		nightc_endnoclip(id)
	}
}
//----------------------------------------------------------------------------------------------
public positionChangeTimer(id)
{
	if ( !is_user_alive(id) ) return

	get_user_origin(id, g_lastPosition[id], 0)

	new Float:velocity[3]
	Entvars_Get_Vector(id, EV_VEC_velocity, velocity)

	if ( velocity[0]==0.0 && velocity[1]==0.0 ) {
		// Force a Move (small jump)
		velocity[0] += 20.0
		velocity[2] += 100.0
		Entvars_Set_Vector(id, EV_VEC_velocity, velocity)
	}

	set_task(0.4,"positionChangeCheck",id)
}
//----------------------------------------------------------------------------------------------
public positionChangeCheck(id)
{
	new origin[3]

	if (!is_user_alive(id) ) return

	get_user_origin(id, origin, 0)
	if ( g_lastPosition[id][0] == origin[0] && g_lastPosition[id][1] == origin[1] && g_lastPosition[id][2] == origin[2] && is_user_alive(id) ) {
		// Kill this player - NightCrawler Stuck in wall!
		user_kill(id)
	}
}
//----------------------------------------------------------------------------------------------
