/*******************************************************************
*     MapConfigX
*
*  by AdaskoMX 2008
*
*  Registered server cmds:
*
*  once			Skips followed command after server restart
*
*  Setinfos:
*
*  playersCount		Average no. of players on previous map
*
*******************************************************************/

#include <amxmodx>
#include <amxmisc>

#define PLUGIN "MapConfigX"
#define VERSION "1.0"
#define AUTHOR "AdaskoMX"

#pragma semicolon 1

#define SERVER_CONFIG 0
#define SERVER_PLUGINS 1
#define SERVER_PRECACHE 2

new map[32];
new dir[64], configs_file[64], plugins_file[64];
new precache_file[64], ftemp_name[64], dynamic_plugins[64];
new bool:restart = false;
new line = 0, bool:same;
new playersP = 0, playersC = 0;

bool:equalInfo(info[]) {
	new infoName[64], sign[3], value[32], valueNow[32], intValue, intValueNow;

	parse(info, infoName, 63, sign, 2, value, 31);
	if(!strlen(sign))
		return false;

	infoName[0] == '%' ?
		get_time(infoName, valueNow, 31) :
		get_localinfo(infoName, valueNow, 31);
	intValueNow = str_to_num(valueNow);
	intValue = str_to_num(value);

	new bool:eq;
	if((strlen(value) && !intValue) || (strlen(valueNow) && !intValueNow))
		eq = equal(value, valueNow) != 0; else
		eq = intValue == intValueNow;
	new bool:bt = intValueNow > intValue;
	new bool:lt = intValueNow < intValue;

	if(equal(sign, "!=") || equal(sign, "<>"))
		return !eq;
	if(sign[0] == '=')
		return eq;
	return (sign[0] == '<' ? lt : bt) || (sign[1] == '=' ? eq : false);
}

handleInfo(info[]) {
	new infoName[64], sign[3], value[32], newValue[32], intValue, intNewValue;
	
	parse(info, infoName, 63, sign, 2, newValue, 31);
	if(!strlen(sign))
		return ;
	
	get_localinfo(infoName, value, 31);
	
	intValue = str_to_num(value);
	intNewValue = str_to_num(newValue);

	if(sign[0] != '=') {
		if(equal(sign, "++"))
			intValue ++; else
		if(equal(sign, "--"))
			intValue --; else
		if(sign[0] == '+')
			intValue += intNewValue; else
		if(sign[0] == '-')
			intValue -= intNewValue;
		num_to_str(intValue, newValue, 31);
	}
	
	set_localinfo(infoName, newValue);
}

bool:equalEx(source[], wildcard[]) {
	new temp[32];
	new bool:res = false;
	new bool:neg = false;
	
	if(strlen(wildcard) && wildcard[0] == '/'){
		neg = true;
		copy(temp, 31, wildcard[1]);
	} else
		copy(temp, 31, wildcard);
	
	if(contain(temp, "*") == -1)
		return (equali(source, temp) != 0) ^ neg;

	if(equal(temp, "*"))
	{
		res = true;
	} else if(strlen(temp) > 1)
	{
		if(temp[0] == '*' && temp[strlen(temp) - 1] == '*')
		{
			copy(temp, strlen(temp) - 2, temp[1]);
			res = containi(source, temp) != -1;
		} else if(temp[strlen(temp) - 1] == '*')
		{
			copy(temp, strlen(temp) - 1, temp);
			res = containi(source, temp) == 0;
		} else if(temp[0] == '*')
		{
			res = equali(source[strlen(source) - strlen(temp) + 1], temp[1]) != 0;
		}
	}
	
	return res ^ neg;
}

bool:mequalEx(source[], wildcards[], cycle = 0) {
	new wildcard[256];
	new prawo[256];
	new bool:res = cycle == 1;
	
	copy(prawo, 255, wildcards);
	
	do {
		split(prawo, wildcard, 255 , prawo, 255, cycle ? " & " : " | ");
		trim(wildcard);
		if(!cycle) {
			res |= mequalEx(source, wildcard, 1);
		} else {
			res &= wildcard[0] == '@' ?
				equalInfo(wildcard[1]) :
				equalEx(source, wildcard);
		}
	} while(strlen(prawo));
	
	return res;	
}

add_plugin(buf[]) {
	write_file(ftemp_name, buf);
	if(same) {
		new len, buf2[256];
		new nline = read_file(dynamic_plugins, line, buf2, 255, len);
		if(nline < 1) {
			same = false;
		} else {
			same = equal(buf, buf2) != 0;
		}
		line ++;
	}
}

end_of_plugins() {
	if(same) {
		new len, dummy[2];
		same = read_file(dynamic_plugins, line, dummy, 1, len) < 1;
	}
}

add_resource(buf[]) {
	new cmd[32], rest[224], len;
	strbreak(buf, cmd, 31, rest, 224);
	
	if(equali("sound", cmd)) {
		precache_sound(rest);
	} else if(equali("model", cmd)) {
		precache_model(rest);
	} else if(equali("generic", cmd)) {
		precache_generic(rest);
	} else {
		if((len = strlen(buf)) < 4) return ;
		copy(cmd, 4, buf[len - 4]);
		strtolower(cmd);
		
		if(equal(cmd, ".mdl") || equal(cmd, ".spr") || equal(cmd, ".wad"))
			precache_model(buf); else
		if(equal(cmd, ".wav") || equal(cmd, ".mp3"))
			precache_sound(buf); else
			precache_generic(buf);			
	}
}

loadConfig( file[], type )
{
	if (!file_exists(file))
		return ;

	new bool:dedicated = is_dedicated_server() != 0;
	new bool:forded = false;
	new bool:forstand = false;
	
	new buf[256];
	new mapRule[256] = "*";
	new bool:ruleMatch = true;
	new pos = 0;
	
	new f = fopen(file, "r");
	
	while (!feof(f)) {
		buf[0] = '^0';
		fgets(f, buf, 255);
		if( (pos = strlen(buf)) ) {
			if(buf[pos - 1] == '^10')
				buf[pos - 1] = '^0';
		}
		
		if(buf[0] == '[' && (pos = contain(buf, "]")) != -1){
			copy(mapRule, pos - 2, buf[1]);

			forded = containi(buf[pos], "D") != -1;
			forstand = containi(buf[pos], "L") != -1;
			
			ruleMatch = mequalEx(map, mapRule);
			
		} else if(!equal(buf, "") && buf[0] != ';' && (buf[0] != '/' || buf[1] != '/') &&
			ruleMatch && 
			((forded & dedicated) || (forstand & !dedicated) || (forded == forstand)))
		{
			if(containi(buf, "#include ") == 0) {
				format(buf, 255, "%s/mapconfig/%s", dir, buf[9]);
				loadConfig( buf, type);
			} else 
			if(equali(buf, "#exit")) {
				break;			
			} else
			if(buf[0] == '@') {
				handleInfo(buf[1]);
			} else {
				switch(type) {
					case 0: server_cmd(buf);
					case 1: add_plugin(buf);
					case 2: add_resource(buf);
				}
			}
		}
	}
	
	fclose(f);
}

onceBlocked() {
	new used[32];
	get_localinfo("xblockedTo", used, 31);
	return equali(used, map);
}

onceX(cmd[], oneblock = 0) {
	if(onceBlocked()) {
		if( oneblock )
			set_localinfo("xblockedTo", "");
		return ;
	}
	server_cmd(cmd);
}

public once(id,level,cid) {
	if (!cmd_access(id,level,cid,1)) {
		return PLUGIN_HANDLED;
	}

	if (read_argc() > 1) {
		new cmd[128];
		read_args(cmd, 127);
		onceX(cmd);
	}
	return PLUGIN_HANDLED;
}

public plugin_precache() {
	get_mapname(map, 31);

	get_configsdir(dir, 63);
	format(configs_file, 63, "%s/mapconfig/config.ini", dir);
	format(plugins_file, 63, "%s/mapconfig/plugins.ini", dir);
	format(precache_file, 63, "%s/mapconfig/resources.ini", dir);

	format(ftemp_name, 63, "%s/mapconfig/plugins.tmp", dir);
	format(dynamic_plugins, 63, "%s/plugins-dynamic.ini", dir);
	
	delete_file(ftemp_name);

	same = true;
	restart = false;
	new bool:fex;

	if(!onceBlocked()) {
		same = fex = file_exists(dynamic_plugins) != 0;
		
		loadConfig( plugins_file, SERVER_PLUGINS );
		end_of_plugins();

		if(same) {
			delete_file(ftemp_name);
		} else {
			delete_file(dynamic_plugins);
			if(rename_file(ftemp_name, dynamic_plugins, 1) || fex) {
				restart = true;
			}
		}
	}

	loadConfig( precache_file, SERVER_PRECACHE );

	return PLUGIN_CONTINUE;
}

public plugin_init() {
	if(restart) {
		onceX("restart", 1);
		return PLUGIN_HANDLED;
	}

	register_plugin(PLUGIN, VERSION, AUTHOR);

	register_srvcmd("once","once");
	set_task(10.0, "playersStats", _, _, _, "b");

	return PLUGIN_CONTINUE;
}

public plugin_cfg() {
	loadConfig( configs_file, SERVER_CONFIG );
	
	return PLUGIN_CONTINUE;
}

public playersStats() {
	playersC += get_playersnum();
	playersP ++;
}

public plugin_end() {
	if(playersP > 12) {
		new num[3];
		num_to_str(playersC / playersP, num, 2);
		set_localinfo("playersCount", num);
	}
	set_localinfo("xblockedTo", map);
}