/**
  * AMX Mod X
  *   V.I.P. Plugin
  *
  * Originally developed by wasntme/Caldeum
  *
  *
  *  This program is free software; you can redistribute it and/or modify it
  *  under the terms of the GNU General Public License as published by the
  *  Free Software Foundation; either version 2 of the License, or (at
  *  your option) any later version.
  *
  *  This program is distributed in the hope that it will be useful, but
  *  WITHOUT ANY WARRANTY; without even the implied warranty of
  *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  *  General Public License for more details.
  *
  *  You should have received a copy of the GNU General Public License
  *  along with this program; if not, write to the Free Software Foundation, 
  *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
  *
  *  In addition, as a special exception, the author gives permission to
  *  link the code of this program with the Half-Life Game Engine ("HL
  *  Engine") and Modified Game Libraries ("MODs") developed by Valve, 
  *  L.L.C ("Valve"). You must obey the GNU General Public License in all
  *  respects for all of the code used other than the HL Engine and MODs
  *  from Valve. If you modify this file, you may extend this exception
  *  to your version of the file, but you are not obligated to do so. If
  *  you do not wish to do so, delete this exception statement from your
  *  version.
  *
  *
  * Link to the plugin
  *
  *	http://forums.alliedmods.net/showthread.php?t=131494
  *
  **/

#include < amxmodx >
#include < amxmisc >
#include < cstrike >
#include < fun >
#include < fakemeta >
#include < fakemeta_util >
#include < hamsandwich >

#define PLUGIN "VIP"
#define VERSION "0.3"
#define AUTHOR "wasntme/Caldeum"

#define VIP_ACCESS ADMIN_LEVEL_H

#define FFADE_IN 0x0000

#define CharsMax(%1) sizeof %1 - 1
#define IsPlayer(%1) ( 1 <= %1 <= g_iMaxPlayers )

const m_LastHitGroup = 75;

new equipment_mode[ 33 ], money_mode[ 33 ], critical_mode[ 33 ], soldier_mode[ 33 ], heavy_mode[ 33 ], medic_mode[ 33 ];
new equipment_active[ 33 ], money_active[ 33 ], critical_active[ 33 ], soldier_active[ 33 ], heavy_active[ 33 ], medic_active[ 33 ];

new bool:g_showrecieved;
new bool:canHeal = true;

new g_iMaxPlayers;
new g_iRoundCount = 0, g_roundendfix;
new g_hudmsg1, g_hudmsg2;
new g_msgFade, g_msgShake;
new g_msgSayText, g_msgTeamInfo;

new p_Enabled, p_Join, p_Damage, p_Type, p_Recieved, p_Defuser, p_Equipment, p_Money, p_Critical, p_Soldier, p_Heavy, p_Medic, p_MoneyGive, p_CriticalChance, p_CriticalDamage, p_SoldierMaxHp, p_SoldierKillHp, p_SoldierArmor, p_HeavyArmor, p_MedicHpRegen, p_MedicHpRegenSpeed, p_MedicMaxHp;

public plugin_init ( )
{
	register_plugin( PLUGIN, VERSION, AUTHOR );
	
	register_event( "HLTV", "event_NewRound", "a", "1=0", "2=0" );
	register_logevent( "event_RoundEnd", 2, "0=World triggered", "1=Round_End" );
	
	RegisterHam( Ham_Spawn, "player", "player_Spawn", 1 );
	RegisterHam( Ham_TraceAttack, "player", "player_Attack" );
	RegisterHam( Ham_TakeDamage, "player", "player_TakeDamage" );
	
	register_event( "DeathMsg", "event_PlayerHeal", "a" );
	register_event( "Damage", "event_ShowDamage", "b", "2!0", "3=0", "4!0" );
	
	register_forward( FM_PlayerPreThink, "pthink" );
	
	p_Enabled 		= 	register_cvar( "amx_vip_script", "1" );
	p_Join 			= 	register_cvar( "amx_vip_join", "1" );
	p_Type 			= 	register_cvar( "amx_vip_damage", "2" );
	p_Recieved 		= 	register_cvar( "amx_vip_damage_recieved", "1" );
	p_Defuser 		= 	register_cvar( "amx_vip_defuser", "1" );
	p_Equipment 		= 	register_cvar( "amx_vip_equipment", "1" );
	p_Money 		= 	register_cvar( "amx_vip_money", "1" );
	p_MoneyGive 		= 	register_cvar( "amx_vip_money_give", "2500" );
	p_Critical 		= 	register_cvar( "amx_vip_critical", "1" );
	p_CriticalChance 	= 	register_cvar( "amx_vip_critical_chance", "15" );
	p_CriticalDamage 	= 	register_cvar( "amx_vip_critical_damage", "2.0" );
	p_Soldier 		= 	register_cvar( "amx_vip_soldier", "1" );
	p_SoldierKillHp 	= 	register_cvar( "amx_vip_soldier_kill_hp", "5" );
	p_SoldierMaxHp 		= 	register_cvar( "amx_vip_soldier_max_hp", "120" );
	p_SoldierArmor 		= 	register_cvar( "amx_vip_soldier_armor", "120" );
	p_Heavy 		= 	register_cvar( "amx_vip_heavy", "1" );
	p_HeavyArmor 		= 	register_cvar( "amx_vip_heavy_armor", "250" );
	p_Medic 		= 	register_cvar( "amx_vip_medic", "1" );
	p_MedicHpRegen 		= 	register_cvar( "amx_vip_medic_hp_regen", "2" );
	p_MedicHpRegenSpeed 	= 	register_cvar( "amx_vip_medic_hp_regen_speed", "2.0" );
	p_MedicMaxHp 		= 	register_cvar( "amx_vip_medic_max_hp", "100" );
	
	register_concmd( "vipmenu", "show_vip_menu" );
	
	register_clcmd( "say /vipmenu", "show_vip_menu" );
	register_clcmd( "say vipmenu", "show_vip_menu" );
	register_clcmd( "say_team /vipmenu", "show_vip_menu" );
	register_clcmd( "say_team vipmenu", "show_vip_menu" );
	register_clcmd( "say /vips", "viplist" );
	register_clcmd( "say vips", "viplist" );
	register_clcmd( "say_team /vips", "viplist" );
	register_clcmd( "say_team vips", "viplist" );
	
	g_hudmsg1 = CreateHudSyncObj( );
	g_hudmsg2 = CreateHudSyncObj( );
	g_msgFade = get_user_msgid( "ScreenFade" );
	g_msgShake = get_user_msgid( "ScreenShake" );
	g_msgSayText = get_user_msgid( "SayText" );
	g_msgTeamInfo = get_user_msgid( "TeamInfo" );
	g_iMaxPlayers = get_maxplayers( );
	
	register_dictionary( "vip.txt" );
}

public client_connect ( id )
{
	if ( get_user_flags( id ) & VIP_ACCESS )
	{
		equipment_mode[ id ] = 0;
		money_mode[ id ] = 0;
		critical_mode[ id ] = 0;
		soldier_mode[ id ] = 0;
		heavy_mode[ id ] = 0;
		medic_mode[ id ] = 0;
	}
}

public client_disconnect ( id ) 
{
	remove_task( id );
	
	if ( get_user_flags( id ) & VIP_ACCESS )
	{
		equipment_mode[ id ] = 0;
		money_mode[ id ] = 0;
		critical_mode[ id ] = 0;
		soldier_mode[ id ] = 0;
		heavy_mode[ id ] = 0;
		medic_mode[ id ] = 0;
	}
}

public client_putinserver ( id )
{
	if ( get_user_flags( id ) & VIP_ACCESS )
	{
		if ( get_pcvar_num( p_Join ) && g_iRoundCount > 1 )
		{
			new name[ 32 ];
			get_user_name( id, name, 31 );
			
			print_color( 0, id, 0, "%L", LANG_SERVER, "VIP_JOIN", name );
		}
	}
}

public event_ShowDamage ( id )
{
	if ( p_Damage )
	{
		static attacker, damage;
		attacker = get_user_attacker( id );
		damage = read_data( 2 );
		
		if ( g_showrecieved  && ( get_user_flags( id ) & VIP_ACCESS ) )
		{			
			set_hudmessage( 200, 20, 20, 0.45, 0.50, 2, 0.1, 4.0, 0.1, 0.1, -1 );
			ShowSyncHudMsg( id, g_hudmsg2, "%i^n", damage );
		}
		
		if ( is_user_connected( attacker ) )
		{
			switch( p_Damage )
			{
				case 1:
				{
					if ( is_user_alive( attacker ) && ( get_user_flags( attacker ) & VIP_ACCESS ) )
					{
						set_hudmessage( 34, 139, 34, -1.0, 0.55, 2, 0.1, 4.0, 0.02, 0.02, -1 );
						ShowSyncHudMsg( attacker, g_hudmsg1, "%i^n", damage );
					}
				}
				case 2:
				{
					if ( is_user_alive( attacker ) && ( get_user_flags( attacker ) & VIP_ACCESS ) && fm_is_ent_visible( attacker, id ) )
					{
						set_hudmessage( 34, 139, 34, -1.0, 0.55, 2, 0.1, 4.0, 0.02, 0.02, -1 );
						ShowSyncHudMsg( attacker, g_hudmsg1, "%i^n", damage );
					}
				}
			}
		}
	}
}

public player_TakeDamage ( VictimId, InflictorId, AttackerId, Float:damage, dmgbits )
{
	if ( IsPlayer( AttackerId ) && critical_active[ AttackerId ] && cs_get_user_team( VictimId ) != cs_get_user_team( AttackerId ) && get_pcvar_num( p_CriticalChance ) > random( 100 ) ) 
	{
		if ( get_user_flags( AttackerId ) & VIP_ACCESS )
		{
			new Float:crit_damage = damage * get_pcvar_float( p_CriticalDamage );
		
			SetHamParamFloat( 4, crit_damage );
			
			new szVictim[ 32 ];
			get_user_name( VictimId, szVictim, 31 );
			
			print_color( AttackerId, AttackerId, 0, "%L", LANG_PLAYER, "VIP_CRITICAL_HIT", szVictim );
			
			client_cmd( AttackerId, "spk silent/vip/player/critical" );
		}
	}
	return HAM_IGNORED;
}

public event_PlayerHeal ( )
{
	new iKiller = read_data( 1 );
	new iVictim = read_data( 2 ); 
	
	if ( get_user_flags( iKiller ) & VIP_ACCESS )
	{
		if ( soldier_active[ iKiller ] && cs_get_user_team( iVictim ) != cs_get_user_team( iKiller ) )
		{
			new MaxHp = get_pcvar_num( p_SoldierMaxHp );
			new BonusHp = get_pcvar_num( p_SoldierKillHp );
			new TotalHp = get_user_health( iKiller ) + BonusHp;
			
			if ( TotalHp >= MaxHp )
			{
				set_user_health( iKiller, MaxHp );
				
				print_color( iKiller, iKiller, 0, "%L", LANG_SERVER, "VIP_SOLDIER_MAX_HP", get_pcvar_num( p_SoldierMaxHp ) );
				
				client_cmd( iKiller, "spk silent/vip/player/maximum" );
				
				message_begin( MSG_ONE_UNRELIABLE, g_msgFade, .player=iKiller );
				{
					write_short( 1<<13 );
					write_short( 1<<5 );
					write_short( FFADE_IN );
					write_byte( 139 );
					write_byte( 34 );
					write_byte( 34 );
					write_byte( 75 );
				}
				message_end( );
				
				message_begin( MSG_ONE_UNRELIABLE, g_msgShake, .player=iKiller );
				{
					write_short( 255<<7 );
					write_short( 50<<7 );
					write_short( 255<<7 );
				}
				message_end( );
			} else {
				set_user_health( iKiller, TotalHp );
				
				print_color( iKiller, iKiller, 0, "%L", LANG_SERVER, "VIP_SOLDIER_HEAL", get_pcvar_num( p_SoldierKillHp ) );
				
				client_cmd( iKiller, "spk silent/vip/items/health" );
				
				message_begin( MSG_ONE_UNRELIABLE, g_msgFade, .player=iKiller );
				{
					write_short( 1<<12 );
					write_short( 1<<5 );
					write_short( FFADE_IN );
					write_byte( 139 );
					write_byte( 34 );
					write_byte( 34 );
					write_byte( 75 );
				}
				message_end( );
				
				message_begin( MSG_ONE_UNRELIABLE, g_msgShake, .player=iKiller );
				{
					write_short( 255<<5 );
					write_short( 50<<5 );
					write_short( 255<<5 );
				}
				message_end( );
			}
		}
	}
}

public player_Attack ( id, iAttacker, Float:flDamage, Float:fVecDir[3], tr )
{
	if ( get_user_flags( id ) & VIP_ACCESS )
	{
		if ( IsPlayer( iAttacker ) && heavy_active[ id ] && cs_get_user_team( id ) != cs_get_user_team( iAttacker ) && get_tr2( tr, TR_iHitgroup ) == HIT_HEAD && get_tr2( tr, TR_iHitgroup ) == HIT_HEAD )
		{
			set_tr2( tr, TR_iHitgroup, HIT_CHEST );
			set_tr2( tr, TR_iHitgroup, HIT_STOMACH );
			
			client_cmd( id, "spk silent/vip/player/headshot" );
			
			message_begin( MSG_ONE_UNRELIABLE, g_msgFade, .player=id );
			{
				write_short( 1<<12 );
				write_short( 1<<5 );
				write_short( FFADE_IN );
				write_byte( 139 );
				write_byte( 34 );
				write_byte( 34 );
				write_byte( 75 );
			}
			message_end( );
			
			message_begin( MSG_ONE_UNRELIABLE, g_msgShake, .player=id );
			{
				write_short( 255<<5 );
				write_short( 50<<5 );
				write_short( 255<<5 );
			}
			message_end( );
		}
	}
}

public waiter ( id )
{
	canHeal = false;
	
	set_task( get_pcvar_float( p_MedicHpRegenSpeed ), "givehp", id );
}

public givehp ( id )
{
	canHeal = true;
	
	new MaxHp = get_pcvar_num( p_MedicMaxHp );
	new BonusHp = get_pcvar_num( p_MedicHpRegen );
	new TotalHp = get_user_health( id ) + BonusHp;
	new hp = pev( id, pev_health );
	
	if ( get_user_flags( id ) & VIP_ACCESS )
	{
		if ( medic_active[ id ] && is_user_alive( id ) && get_user_weapon( id ) == CSW_KNIFE )
		{
			if ( TotalHp >= MaxHp )
			{
				set_user_health( id, MaxHp );
				
				print_color( id, id, 0, "%L", LANG_SERVER, "VIP_MEDIC_MAX_HP", get_pcvar_num( p_MedicMaxHp ) );
				
				client_cmd( id, "spk silent/vip/player/maximum" );
				
				message_begin( MSG_ONE_UNRELIABLE, g_msgFade, .player=id );
				{
					write_short( 1<<13 );
					write_short( 1<<5 );
					write_short( FFADE_IN );
					write_byte( 134 );
					write_byte( 34 );
					write_byte( 34 );
					write_byte( 75 );
				}
				message_end( );
				
				message_begin( MSG_ONE_UNRELIABLE, g_msgShake, .player=id );
				{
					write_short( 255<<7 );
					write_short( 50<<7 );
					write_short( 255<<7 );
				}
				message_end( );
			} else {
				set_user_health( id, hp + BonusHp );
				
				client_cmd( id, "spk silent/vip/items/health" );
				
				message_begin( MSG_ONE_UNRELIABLE, g_msgFade, .player=id );
				{
					write_short( 1<<12 );
					write_short( 1<<5 );
					write_short( FFADE_IN );
					write_byte( 134 );
					write_byte( 34 );
					write_byte( 34 );
					write_byte( 75 );
				}
				message_end( );
				
				message_begin( MSG_ONE_UNRELIABLE, g_msgShake, .player=id );
				{
					write_short( 255<<5 );
					write_short( 50<<5 );
					write_short( 255<<5 );
				}
				message_end( );
			}
		}
	}
}

public pthink ( id )
{
	if ( medic_active[ id ] )
	{
		if ( canHeal && ( pev( id, pev_health ) < 100) )
		{
			waiter( id );
		}
	}
	return FMRES_HANDLED;
}

public show_vip_menu ( id )
{
	if ( get_user_flags( id ) & VIP_ACCESS )
	{
		if ( !get_pcvar_num( p_Enabled ) )
		{
			print_color( id, id, 0, "%L", LANG_SERVER, "VIP_MENU_DISSABLE" );
			client_cmd( id, "spk silent/vip/noaccess" );
		}
		
		if ( get_pcvar_num( p_Enabled ) )
		{
			if ( g_iRoundCount < 1 )
			{
				print_color( id, id, 0, "%L", LANG_SERVER, "VIP_WAIT" );
				client_cmd( id, "spk silent/vip/attention" );
				return PLUGIN_HANDLED;
			}
			
			client_cmd( id, "spk silent/vip/menu/open" );
			new menu = menu_create( "\rV.I.P. Menu \wv\r0\w.\r3 \wstable", "menu" );
			
			if ( !equipment_mode[ id ] && get_pcvar_num( p_Equipment ) )
			{
				menu_additem( menu, "Equipment \y(All required items)", "1", 0 );
			}
			else if ( equipment_mode[ id ] )
			{
				menu_additem( menu, "\dEquipment \r* \y(All required items)", "1", 0 );
			}
			else if ( !get_pcvar_num( p_Equipment ) )
			{
				menu_additem( menu, "\dEquipment (\rdissabled\d)", "1", 0 );
			}
			
			if ( !money_mode[ id ] && get_pcvar_num( p_Money ) )
			{
				menu_additem( menu, "Extra Money \y(+2.500 dollars)", "2", 0 );
			}
			else if ( money_mode[ id ] )
			{
				menu_additem( menu, "\dExtra Money \r* \y(+2.500 dollars)", "2", 0 );
			}
			else if ( !get_pcvar_num( p_Money ) )
			{
				menu_additem( menu, "\dExtra Money (\rdissabled\d)", "2", 0 );
			}
			
			if ( !critical_mode[ id ] && get_pcvar_num( p_Critical ) )
			{
				menu_additem( menu, "Critical Damage \y(Chance to do a Critical Hit is 15%)", "3", 0 );
			}
			else if ( critical_mode[ id ] )
			{
				menu_additem( menu, "\dCritical Damage \r* \y(Chance to do a Critical Hit is 15%)", "3", 0 );
			}
			else if ( !get_pcvar_num( p_Critical ) )
			{
				menu_additem( menu, "\dCritical Damage (\rdissabled\d)", "3", 0 );
			}
			
			if ( !soldier_mode[ id ] && get_pcvar_num( p_Soldier ) )
			{
				menu_additem( menu, "Soldier \y(150AP and +5HP for every kill)", "4", 0 );
			}
			else if ( soldier_mode[ id ] )
			{ 
				menu_additem( menu, "\dSoldier \r* \y(150AP and +5HP for every kill)", "4", 0 );
			}
			else if ( !get_pcvar_num( p_Soldier ) )
			{
				menu_additem( menu, "\dSoldier (\rdissabled\d)", "4", 0 );
			}
			
			if ( !heavy_mode[ id ] && get_pcvar_num( p_Heavy ) )
			{
				menu_additem( menu, "Heavy \y(250AP and immunity for Head Shot)", "5", 0 );
			}
			else if ( heavy_mode[ id ] )
			{
				menu_additem( menu, "\dHeavy \r* \y(250AP and immunity for Head Shot)", "5", 0 );
			}
			else if ( !get_pcvar_num( p_Heavy ) )
			{
				menu_additem( menu, "\dHeavy (\rdissabled\d)", "5", 0 );
			}
			
			if ( !medic_mode[ id ] && get_pcvar_num( p_Medic ) )
			{
				menu_additem( menu, "Medic \y(HP regeneration when holding a Knife)", "6", 0 );
			}
			else if ( medic_mode[ id ] )
			{
				menu_additem( menu, "\dMedic \r* \y(HP regeneration when holding a Knife)", "6", 0 );
			}
			else if ( !get_pcvar_num( p_Medic ) )
			{
				menu_additem( menu, "\dMedic (\rdissabled\d)", "6", 0 );
			}
			
			menu_additem( menu, "\rTurn off all functions", "7", 0 );
			
			menu_setprop( menu, MPROP_EXIT, MEXIT_ALL );
			menu_setprop( menu, MPROP_NUMBER_COLOR, "\r" );
			menu_setprop( menu, MPROP_BACKNAME, "Back" );
			menu_setprop( menu, MPROP_NEXTNAME, "Next" );
			menu_setprop( menu, MPROP_EXITNAME, "Quit" );
			menu_setprop( menu, MPROP_PERPAGE, 7 );
			menu_display( id, menu, 0 );
		}
	}
	
	else if ( get_user_flags( id ) != VIP_ACCESS )
	{
		print_color( id, id, 0, "%L", LANG_SERVER, "VIP_NO_ACCESS" );
		client_cmd( id, "spk silent/vip/noaccess" );
	}
	return PLUGIN_HANDLED;
}

public menu ( id, menu, item )
{
	if ( item == MENU_EXIT )
	{
		client_cmd( id, "spk silent/vip/menu/button" );
		client_cmd( id, "spk silent/vip/menu/close" );
		menu_destroy( menu );
		
		return PLUGIN_HANDLED;
	}
    	
	new data[ 6 ], iName[ 64 ];
	new access, callback;
	menu_item_getinfo( menu, item, access, data,5, iName, 63, callback );
	
	new key = str_to_num( data );
	switch( key )
	{
		case 1:
		{
			if ( !equipment_mode[ id ] && get_pcvar_num( p_Equipment ) )
			{
				equipment_mode[ id ] = 1;
				money_mode[ id ] = 0;
				critical_mode[ id ] = 0;
				soldier_mode[ id ] = 0;
				heavy_mode[ id ] = 0;
				medic_mode[ id ] = 0;
				
				client_cmd( id, "spk silent/vip/menu/button" );
				print_color( id, id, 0, "%L", LANG_SERVER, "VIP_EQUIPMENT_FUNCTION" );
			}
			else if ( equipment_mode[ id ] )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
			else if ( !get_pcvar_num( p_Equipment ) )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
		}
		case 2:
		{
			if ( !money_mode[ id ] && get_pcvar_num( p_Money ) )
			{
				equipment_mode[ id ] = 0;
				money_mode[ id ] = 1;
				critical_mode[ id ] = 0;
				soldier_mode[ id ] = 0;
				heavy_mode[ id ] = 0;
				medic_mode[ id ] = 0;
				
				client_cmd( id, "spk silent/vip/menu/button" );
				print_color( id, id, 0, "%L", LANG_SERVER, "VIP_MONEY_FUNCTION" );
			}
			else if ( money_mode[ id ] )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
			else if ( !get_pcvar_num( p_Money ) )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
		}
		case 3:
		{
			if ( !critical_mode[ id ] && get_pcvar_num( p_Critical ) )
			{
				equipment_mode[ id ] = 0;
				money_mode[ id ] = 0;
				critical_mode[ id ] = 1;
				soldier_mode[ id ] = 0;
				heavy_mode[ id ] = 0;
				medic_mode[ id ] = 0;
				
				client_cmd( id, "spk silent/vip/menu/button" );
				print_color( id, id, 0, "%L", LANG_SERVER, "VIP_CRITICAL_FUNCTION" );
			}
			else if ( critical_mode[ id ] )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
			else if ( !get_pcvar_num( p_Critical ) )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
		}
		case 4:
		{
			if ( !soldier_mode[ id ] && get_pcvar_num( p_Soldier ) )
			{
				equipment_mode[ id ] = 0;
				money_mode[ id ] = 0;
				critical_mode[ id ] = 0;
				soldier_mode[ id ] = 1;
				heavy_mode[ id ] = 0;
				medic_mode[ id ] = 0;
				
				client_cmd( id, "spk silent/vip/menu/button" );
				print_color( id, id, 0, "%L", LANG_SERVER, "VIP_SOLDIER_FUNCTION" );
			}
			else if ( soldier_mode[ id ] )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
			else if ( !get_pcvar_num( p_Soldier ) )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
		}
		case 5:
		{
			if ( !heavy_mode[ id ] && get_pcvar_num( p_Heavy ) )
			{
				equipment_mode[ id ] = 0;
				money_mode[ id ] = 0;
				critical_mode[ id ] = 0;
				soldier_mode[ id ] = 0;
				heavy_mode[ id ] = 1;
				medic_mode[ id ] = 0;
				
				client_cmd( id, "spk silent/vip/menu/button" );
				print_color( id, id, 0, "%L", LANG_SERVER, "VIP_HEAVY_FUNCTION" );
			}
			else if ( heavy_mode[ id ] )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
			else if ( !get_pcvar_num( p_Heavy ) )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
		}
		case 6:
		{
			if ( !medic_mode[ id ] && get_pcvar_num( p_Medic ) )
			{
				equipment_mode[ id ] = 0;
				money_mode[ id ] = 0;
				critical_mode[ id ] = 0;
				soldier_mode[ id ] = 0;
				heavy_mode[ id ] = 0;
				medic_mode[ id ] = 1;
				
				client_cmd( id, "spk silent/vip/menu/button" );
				print_color( id, id, 0, "%L", LANG_SERVER, "VIP_MEDIC_FUNCTION" );
			}
			else if ( medic_mode[ id ] )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
			else if ( !get_pcvar_num( p_Medic ) )
			{
				client_cmd( id, "spk silent/vip/menu/close" );
			}
		}
		case 7:
		{
			equipment_mode[ id ] = 0;
			money_mode[ id ] = 0;
			critical_mode[ id ] = 0;
			soldier_mode[ id ] = 0;
			heavy_mode[ id ] = 0;
			medic_mode[ id ] = 0;
			
			client_cmd( id, "spk silent/vip/menu/button" );
			print_color( id, id, 0, "%L", LANG_SERVER, "VIP_DISSABLE_FUNCTIONS" );
			client_cmd( id, "spk silent/vip/items/dissable" );
		}
	}
	return PLUGIN_HANDLED;
}

public event_NewRound ( id )
{
	g_iRoundCount++;
	
	p_Damage = get_pcvar_num( p_Type );
	
	if ( get_pcvar_num( p_Recieved ) )
	{
		g_showrecieved = true;
	}
}

public event_RoundEnd ( id )
{
	g_roundendfix = 1;
}

public player_Spawn ( id )
{
	if ( get_user_flags( id ) & VIP_ACCESS )
	{
		if ( get_pcvar_num( p_Enabled ) && g_roundendfix )
		{
			if ( is_user_alive( id ) )
			{
				equipment_active[ id ] = 0;
				money_active[ id ] = 0;
				critical_active[ id ] = 0;
				soldier_active[ id ] = 0;
				heavy_active[ id ] = 0;
				medic_active[ id ] = 0;
				
				if ( g_iRoundCount == 1 )
				{
					show_vip_menu( id );
				}
				
				if ( equipment_mode[ id ] )
				{
					equipment_active[ id ] = 1;
					equipment( id );
				}
				
				if ( money_mode[ id ] )
				{
					money_active[ id ] = 1;
					money( id );
				}
				
				if ( critical_mode[ id ] )
				{
					critical_active[ id ] = 1;
					critical( id );
				}
					
				if ( soldier_mode[ id ] )
				{
					soldier_active[ id ] = 1;
					soldier( id );
				}
				
				if ( heavy_mode[ id ] )
				{
					heavy_active[ id ] = 1;
					heavy( id );
				}
				
				if ( medic_mode[ id ] )
				{
					medic_active[ id ] = 1;
					medic( id );
				}
				
				if ( p_Defuser )
				{
					if ( fm_find_ent_by_class( -1, "func_bomb_target" ) || fm_find_ent_by_class( -1, "info_bomb_target" ) )
					{
						if ( cs_get_user_team( id ) == CS_TEAM_CT )
						{
							fm_give_item( id, "item_thighpack" );
						}
					}
				}
			}
		}
	}
}

public equipment ( id )
{
	if ( equipment_active[ id ] )
	{
		cs_set_user_armor( id, 100, CS_ARMOR_VESTHELM );
		
		fm_give_item( id, "weapon_hegrenade" );
		fm_give_item( id, "weapon_flashbang" );
		fm_give_item( id, "weapon_flashbang" );
		
		cs_set_user_bpammo( id, CSW_USP, 100 );
		cs_set_user_bpammo( id, CSW_ELITE, 120 );
		cs_set_user_bpammo( id, CSW_DEAGLE, 35) ;
		cs_set_user_bpammo( id, CSW_GLOCK18, 120) ;
		cs_set_user_bpammo( id, CSW_P228, 52 );
		cs_set_user_bpammo( id, CSW_FIVESEVEN, 100 );
		cs_set_user_bpammo( id, CSW_XM1014, 32 );
		cs_set_user_bpammo( id, CSW_M3, 32 );
		cs_set_user_bpammo( id, CSW_P90, 100 );
		cs_set_user_bpammo( id, CSW_MAC10, 100 );
		cs_set_user_bpammo( id, CSW_MP5NAVY, 120 );
		cs_set_user_bpammo( id, CSW_TMP, 120 );
		cs_set_user_bpammo( id, CSW_UMP45, 100 );
		cs_set_user_bpammo( id, CSW_FAMAS, 90 );
		cs_set_user_bpammo( id, CSW_GALIL, 90 );
		cs_set_user_bpammo( id, CSW_SCOUT, 90 );
		cs_set_user_bpammo( id, CSW_AUG, 90 );
		cs_set_user_bpammo( id, CSW_M4A1, 90 );
		cs_set_user_bpammo( id, CSW_AK47, 90 );
		cs_set_user_bpammo( id, CSW_SG552, 90 );
		cs_set_user_bpammo( id, CSW_G3SG1, 90 );
		cs_set_user_bpammo( id, CSW_SG552, 90 );
		cs_set_user_bpammo( id, CSW_AWP, 30 );
		cs_set_user_bpammo( id, CSW_M249, 200 );
		
		print_color( id, id, 0, "%L", LANG_SERVER, "VIP_EQUIPMENT" );
		
		set_task( 0.1, "shake", id );
	}
}

public money ( id )
{
	if ( money_active[ id ] )
	{
		new MaxMoney = 16000;
		new BonusMoney = get_pcvar_num( p_MoneyGive );
		new TotalMoney = cs_get_user_money( id ) + BonusMoney;
		
		if ( TotalMoney >= MaxMoney )
		{
			cs_set_user_money( id, MaxMoney );
			
			print_color( id, id, 0, "%L", LANG_SERVER, "VIP_MONEY_MAX", get_pcvar_num( p_MoneyGive ) );
			
			client_cmd( id, "spk silent/vip/items/money_max" );
			
			set_task( 0.1, "shake", id );
			
			show_vip_menu( id );
		} else {
			cs_set_user_money( id, TotalMoney );
			
			print_color( id, id, 0, "%L", LANG_SERVER, "VIP_MONEY", get_pcvar_num( p_MoneyGive ) );
			
			set_task( 0.1, "shake", id );
		}
	}
}

public critical ( id )
{
	if ( critical_active[ id ] )
	{
		print_color( id, id, 0, "%L", LANG_SERVER, "VIP_CRITICAL", get_pcvar_num( p_CriticalChance ) );
		
		set_task( 0.1, "shake", id );
	}
}

public soldier ( id )
{
	if ( soldier_active[ id ] )
	{
		cs_set_user_armor( id, get_pcvar_num( p_SoldierArmor ), CS_ARMOR_VESTHELM );
		
		print_color( id, id, 0, "%L", LANG_SERVER, "VIP_SOLDIER", get_pcvar_num( p_SoldierArmor ), get_pcvar_num( p_SoldierKillHp ) );
		
		set_task( 0.1, "shake", id );
	}
}

public heavy( id )
{
	if ( heavy_active[ id ] )
	{
		cs_set_user_armor( id, get_pcvar_num( p_HeavyArmor ), CS_ARMOR_VESTHELM );
		
		print_color( id, id, 0, "%L", LANG_SERVER, "VIP_HEAVY", get_pcvar_num( p_HeavyArmor ) );
		
		set_task( 0.1, "shake", id );
	}
}

public medic ( id )
{
	if ( medic_active[ id ] )
	{
		print_color( id, id, 0, "%L", LANG_SERVER, "VIP_MEDIC", get_pcvar_num( p_MedicHpRegen ), get_pcvar_num( p_MedicHpRegenSpeed ) );
		
		set_task( 0.1, "shake", id );
	}
}

public viplist ( id )
{
	static sPlayers[ 32 ], iNum, iPlayer;
	static sName[ 32 ], sBuffer[ 1024 ];
	static iLen;
	
	iLen = formatex( sBuffer, sizeof sBuffer - 1, "<html><head><link rel='stylesheet' type='text/css' href='http://silent.lt/motd/motd.css' media='screen' />" );
	iLen += formatex( sBuffer[ iLen ], CharsMax( sBuffer ) - iLen,"<html><head><link rel='stylesheet' type='text/css' href='http://silent.lt/motd/motd.css' media='screen' />" );
	
	get_players( sPlayers, iNum, "ch" );
	
	iLen += formatex( sBuffer[ iLen ], CharsMax( sBuffer ) - iLen, "<center><img src='http://silent.lt/images/vips.png'></img></center><br>" );
	
	for( new x = 0; x < iNum ; x++ )
	{   
		iPlayer = sPlayers[ x ];
		
		if ( get_user_flags( iPlayer ) & VIP_ACCESS )
		{
			get_user_name( iPlayer, sName, sizeof sName - 1 );
			iLen += formatex( sBuffer[ iLen ], CharsMax( sBuffer ) - iLen, "<left>%s</left><br>", sName );
		}
	}
	
	show_motd( id, sBuffer, "Vip's Online" );
	return 0;
}

public shake ( id )
{
	client_cmd( id, "spk silent/vip/items/give_item" );
	
	message_begin( MSG_ONE_UNRELIABLE, g_msgFade, .player=id );
	{
		write_short( 1<<14 );
		write_short( 1<<5 );
		write_short( FFADE_IN );
		write_byte( 34 );
		write_byte( 34 );
		write_byte( 139 );
		write_byte( 75 );
	}
	message_end( );
	
	message_begin( MSG_ONE_UNRELIABLE, g_msgShake, .player=id );
	{
		write_short( 255<<15 );
		write_short( 50<<8 );
		write_short( 255<<15 );
	}
	message_end( );
}

public print_color ( id, cid, color, const message[ ], any:... )
{
	new msg[ 192 ];
	vformat( msg, charsmax( msg ), message, 5 );
	
	replace_all( msg, charsmax( msg ), "!g", "^x04" );
	replace_all( msg, charsmax( msg ), "!n", "^x01" );
	replace_all( msg, charsmax( msg ), "!t", "^x03" );
	
	new param;
	
	if ( !cid )
	{
		return;
	} else {
		param = cid;
	}
	
	new team[ 32 ];
	get_user_team( param, team, 31 );
	
	switch ( color )
	{
		case 0: msg_teaminfo( param, team );
		case 1: msg_teaminfo( param, "TERRORIST" );
		case 2: msg_teaminfo( param, "CT" );
		case 3: msg_teaminfo( param, "SPECTATOR" );
	}
	
	if ( id )
	{
		msg_saytext( id, param, msg );
	} else {
		msg_saytext( 0, param, msg );
	}
	
	if ( color != 0 )
	{
		msg_teaminfo( param, team );
	}
}

msg_saytext ( id, cid, msg[ ] )
{
	message_begin( id?MSG_ONE:MSG_ALL, g_msgSayText, {0,0,0}, id );
	write_byte( cid );
	write_string( msg );
	message_end( );
}

msg_teaminfo ( id, team[ ] )
{
	message_begin( MSG_ONE, g_msgTeamInfo, {0,0,0}, id );
	write_byte( id );
	write_string( team );
	message_end( );
}

public plugin_precache ( )
{
	if ( file_exists( "sound/silent/vip/noaccess.wav" ) )
		precache_sound( "silent/vip/noaccess.wav" );
	
	if ( file_exists( "sound/silent/vip/attention.wav" ) )
		precache_sound( "silent/vip/attention.wav" );
	
	if ( file_exists( "sound/silent/vip/menu/open.wav" ) )
		precache_sound( "silent/vip/menu/open.wav" );
	
	if ( file_exists( "sound/silent/vip/menu/button.wav" ) )
		precache_sound( "silent/vip/menu/button.wav" );
	
	if ( file_exists( "sound/silent/vip/items/give_item.wav" ) )
		precache_sound( "silent/vip/items/give_item.wav" );
	
	if ( file_exists( "sound/silent/vip/items/money_max.wav" ) )
		precache_sound( "silent/vip/items/money_max.wav" );
	
	if ( file_exists( "sound/silent/vip/player/headshot.wav" ) )
		precache_sound( "silent/vip/player/headshot.wav" );
	
	if ( file_exists( "sound/silent/vip/player/critical.wav" ) )
		precache_sound( "silent/vip/player/critical.wav" );
	
	if ( file_exists( "sound/silent/vip/player/maximum.wav" ) )
		precache_sound( "silent/vip/player/maximum.wav" );
	
	if ( file_exists( "sound/silent/vip/items/health.wav" ) )
		precache_sound( "silent/vip/items/health.wav" );
	
	if ( file_exists( "sound/silent/vip/items/dissable.wav" ) )
		precache_sound( "silent/vip/items/dissable.wav" );
	
	if ( file_exists( "sound/silent/vip/menu/close.wav" ) )
		precache_sound( "silent/vip/menu/close.wav" );
}
