/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <sockets>

#define PLUGIN "Twitter Status"
#define VERSION "0.1.0"
#define AUTHOR "PomanoB"

#define MAX_CONNECTIONS 3
#define BUFFER_SIZE 4024

new g_recvData[MAX_CONNECTIONS][BUFFER_SIZE]
new g_sockets[MAX_CONNECTIONS]
new g_user[MAX_CONNECTIONS]
new g_twittUser[MAX_CONNECTIONS][64]

new g_curr_socket

new g_lastRequest[33]

new g_cvar_interval

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_clcmd("say", "cmdSay")
	register_clcmd("say_team", "cmdSay")
	
	g_cvar_interval = register_cvar("twitt_interval", "60")
}

public client_putinserver(id)
{
	g_lastRequest[id] = 0
}

public cmdSay(id)
{
	new saycmd[64]
	read_argv(1, saycmd, charsmax(saycmd))
	if (equal(saycmd, "/twitt", 6))
	{
		if (saycmd[7])
		{
			new interval = get_pcvar_num(g_cvar_interval)
			new currTime = get_systime()
			interval -= (currTime - g_lastRequest[id])
			
			if (interval <= 0)
			{
				client_print(id, print_chat, "Loading...")
				g_lastRequest[id] = currTime
				getData(id, saycmd[7])
			}
			else
				client_print(id, print_chat, "Wait %d second!", interval)
		}
		else
			client_print(id, print_chat, "Usage: /twitt <username>")
		return PLUGIN_HANDLED
	}
	return PLUGIN_CONTINUE
}

public getData(id, user[])
{
	new error
	new socket = socket_open("api.twitter.com", 80, SOCKET_TCP, error)
	if (error)
		return error
	new get[128]
	formatex(get, charsmax(get), "GET /1/statuses/user_timeline.xml?trim_user=true&count=1&screen_name=%s HTTP/1.1^r^nHost: api.twitter.com^r^n^r^n", user)
	socket_send(socket, get, 0)
	
	g_curr_socket++
	if (g_curr_socket >= MAX_CONNECTIONS)
		g_curr_socket = 0
	
	if (g_sockets[g_curr_socket])
	{
		client_print(id, print_chat, "Sorry! Try again later!")
		return 4
	}
	
	g_sockets[g_curr_socket] = socket
	g_user[g_curr_socket] = id
	copy(g_twittUser[g_curr_socket], 63, user)
	
	set_task(1.0, "recvTask", g_curr_socket, _, _, "a", 5)
	set_task(6.0, "closeSocket", g_curr_socket)
		
	return 0
}

public recvTask(socketNumber)
{
	new socket = g_sockets[socketNumber]
	if (socket_change(socket, 1))
	{
		setc(g_recvData[socketNumber], BUFFER_SIZE - 1, 0)
		socket_recv(socket, g_recvData[socketNumber], BUFFER_SIZE - 1)
		
		if (contain(g_recvData[socketNumber], "Status: 404") >= 0)
		{
			userNotFound(socketNumber)
			closeSocket(socketNumber)
			return
		}
		new textStart = contain(g_recvData[socketNumber], "<text>")
		new textEnd = contain(g_recvData[socketNumber], "</text>")
		new status[1024]
		if (textStart >= 0)
		{
			copy(status, min(charsmax(status), textEnd - textStart - 6), g_recvData[socketNumber][textStart + 6])
			showStatus(socketNumber, status)
			
			remove_task(socketNumber)
			closeSocket(socketNumber)
		}
	}
}

public closeSocket(socketNumber)
{
	socket_close(g_sockets[socketNumber])
	g_sockets[socketNumber] = 0
	g_user[socketNumber] = 0
	setc(g_twittUser[g_curr_socket], 63, 0)
}

public userNotFound(n)
{
	new id = g_user[n]
	client_print(id, print_chat, "User %s no in twitter!", g_twittUser[g_curr_socket])
}

public showStatus(number, status[])
{
	new id = g_user[number]
	
	new output[1024]
	encodeHtml(status, output)
	
	set_hudmessage(255, 255, 255, 0.02, -1.0, 2, 6.0, 6.0)
	show_hudmessage(id, "%s: %s", g_twittUser[g_curr_socket], output)
	
}

public encodeHtml(string[], output[])
{
	new i, len, j, symbol[7], end, k, utf[4], code
	len = strlen(string)
	while(string[i])
	{
		if (i < len - 1 && string[i] == '&' && string[i+1] == '#')
		{
			
			setc(symbol, 0, 6)
			end = copyc(symbol, charsmax(symbol), string[i+2], ';')
			i += (end + 2)
			
			if (symbol[0] == 'x')
				code = hexdec(symbol)
			else
				code = str_to_num(symbol)
				
			k = code2utf8(code, utf)
			for(code = 0; code < k; code++)
			{
				output[j++] = utf[code]
			}
		}
		else
			output[j++] = string[i]
		i++
	}
}

public hexdec(hex[])
{
	new curr = strlen(hex) - 1
	new result, currD, s
	while(curr >= 0)
	{
		s = hex[curr]
		if (48 <= s <= 57)
			s -= 48
		else
		if (65 <= s <= 70)
			s -= 55
		else
		if (97 <= s <= 102)
			s -= 87
		else
		if (s == 'x')
			return result
		else
			return 0
			
		result += (power(16, currD++) * s)
		curr --
	}
	return result
}

public code2utf8(code, output[4])
{
	if (code < 128)
	{
		output[0] = code
		return 1
	}
	if (code < 2048)
	{
		output[0] = ((code >> 6) + 192)
		output[1] = ((code & 63) + 128)
		return 2
	}
	if (code < 65536)
	{
		output[0] = ((code >> 12) + 224)
		output[0] = (((code >> 6) & 63) + 128)
		output[0] = ((code & 63) + 128)
		return 3
	}
	if (code < 2097152)
	{
		output[0] = ((code >> 18) + 240)
		output[0] =(((code >> 12) & 63) + 128)
		output[0] = (((code >> 6) & 63) + 128)
		output[0] = ((code & 63) + 128)
		return 4
	}
	return 0;
}
