/**
 *
 * HotVision
 *  by Numb
 *
 *
 * Description:
 *  This plugin gives some use for nightvision. Normally nightvision only helps in case
 *  if players are close enough. This plugin makes all players visible in the dark, plus
 *  it includes support for infrared (ability to see through some walls/objects),
 *  heart-beat device (radar showing enemies with 1024 units range by default) what
 *  refreshes every 2 seconds, advanced hotvision (not only players are fully visible
 *  in dark places, but also other objects like hostages, weapons...). Also this plugin
 *  includes a fix for switching off nightvision by "fullupdate" command or and when
 *  starting to record a demo.
 *
 *
 * Requires:
 *  FakeMeta
 *  HamSandWich
 *
 *
 * Additional Info:
 *  Tested in Counter-Strike 1.6 with amxmodx 1.8.1. You can disable/edit some features via
 *  plugin config. Features like infrared (can be disabled/enabled), advanced hotvision
 *  (disabled/enabled), heart-beat device (disable/enable and set range).
 *
 *
 * Notes:
 *  Some of plugins what I made (like Fast Sniper Switch [ http://forums.alliedmods.net/showthread.php?p=1193990 ],
 *  CS1.5 Silencer [ http://forums.alliedmods.net/showthread.php?p=1194755 ],
 *  Real Weapon Speed [ url=http://forums.alliedmods.net/showthread.php?p=864835 ]) are hard to notice
 *  and be aware of their advantages when playing against others. In order to fix that I made a
 *  chat message what shows up first time you spawn telling you that you can type "/plugins_by_numb"
 *  in chat and see what hard-noticeable game-play plugins server has. This supports only
 *  my plugins and the ones what are up-to-date and have this feature.
 *
 *
 * Warnings:
 *  - Use only one of the plugins you find below, or configurate it the way you like.
 *  - To other coders. Please don't use my "plugins_by_numb" system for your plugins,
 *   cause I am keeping track of what plugin-id-flag I included in the system, and messing
 *   up with that can lead to some menu issues. You can recreate the system, but in that
 *   case please change the cvar what keeps the track of it, and also do not forget to
 *   change menu-string-name to avoid glitches
 *
 *
 * ChangeLog:
 *
 *  + 1.4
 *  - Changed: Less CPU usage, more stability.
 *
 *  + 1.3
 *  - Fixed: Error when someone disconnects and other person is spectating him.
 *  - Fixed: Error when using "fullupdate" command.
 *
 *  + 1.2
 *  - Fixed: Glitch that nightvision isn't always restored after "fullupdate" command.
 *
 *  + 1.1
 *  - Fixed: Glitch with having nightvision when you shouldn't when spamming "fullupdate" command.
 *  - Changed: Less CPU usage.
 *
 *  + 1.0
 *  - First release.
 *
 *
 * Downloads:
 *  Amx Mod X forums: http://forums.alliedmods.net/showthread.php?p=1274017#post1274017
 *
**/

// ----------------------------------------- CONFIG START -----------------------------------------

// Comment "#define HOTVISION_MODELS" line if you want hotvision to detect only players.
#define HOTVISION_MODELS // default: uncommented

// Comment "#define HOTVISION_WALLS" line if you want to disable infrared (for solid walls).
#define HOTVISION_WALLS // default: uncommented

// Unomment "#define HOTVISION_RADAR" line if you want heart-beat device (enemy radar)
//#define HOTVISION_RADAR // default: commented

// What distance in units should heart-beat device work? Comment it for unlimited range.
#define RADAR_DISTANCE 1024 // default: 1024

// If you are having trouble with heart-beat device what can be caused by many hostages or other
// plugins what use hostage system to show something on radar - please change this value to a
// higher one. NOTE: Highest value what you can use is 255-maxplayers, and lowest value should be
// maximal number of hostages what you can have on your server in some specific map.
#define RADARID_OFFSET 16 // default: 16

// ------------------------------------------ CONFIG END ------------------------------------------


#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>

#define PLUGIN_NAME	"HotVision"
#define PLUGIN_VERSION	"1.4"
#define PLUGIN_AUTHOR	"Numb"
#define PLUGIN_LINK	"http://forums.alliedmods.net/showthread.php?p=1274017#post1274017"
#define PLUGIN_PBNID 	1 // (1<<0)

#define PDPlayerState 129
#define PDPlrStateNvg (1<<8) // 256

new g_iMaxPlayers;
new g_iMsgId_NVGToggle;
new bool:g_bConnected[33];
new bool:g_bAlive[33];
new bool:g_bUpdateData[33];
new bool:g_bInNvg[33];
#if defined HOTVISION_RADAR
new g_iMsgId_HostagePos;
new g_iMsgId_HostageK;
#if defined RADAR_DISTANCE
new Float:g_fRadarRange;
#endif
#endif

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR);
	
	RegisterHam(Ham_Spawn,  "player", "Ham_Spawn_player_Post",  1);
	RegisterHam(Ham_Killed, "player", "Ham_Killed_player_Post", 1);
	
	register_forward(FM_StartFrame,    "FM_StartFrame_Pre",     0);
	register_forward(FM_AddToFullPack, "FM_AddToFullPack_Post", 1);
	
	register_event("ResetHUD",  "Event_ResetHUD",  "be");
	
#if defined HOTVISION_RADAR
	register_event("NVGToggle", "Event_NVGToggle", "be");
		
	g_iMsgId_HostagePos = get_user_msgid("HostagePos");
	g_iMsgId_HostageK   = get_user_msgid("HostageK");
#if defined RADAR_DISTANCE
	g_fRadarRange = float(clamp(RADAR_DISTANCE, 128, 8192));
#endif
#endif
	g_iMsgId_NVGToggle = get_user_msgid("NVGToggle");
	g_iMaxPlayers = clamp(get_maxplayers(), 1, 32);
	
	pl_by_numb_init();
}

public plugin_cfg()
	pl_by_numb_cfg();

public client_putinserver(iPlrId)
	g_bConnected[iPlrId] = true;

public client_disconnect(iPlrId)
{
	g_bConnected[iPlrId] = false;
	g_bAlive[iPlrId] = false;
	
#if defined HOTVISION_RADAR
	if( task_exists(iPlrId) )
		remove_task(iPlrId);
#endif
	if( task_exists(iPlrId+32) )
		remove_task(iPlrId+32);
	if( task_exists(iPlrId+64) )
		remove_task(iPlrId+64);
	if( task_exists(iPlrId+96) )
		remove_task(iPlrId+96);
	if( task_exists(iPlrId+128) )
		remove_task(iPlrId+128)
}

public Ham_Spawn_player_Post(iPlrId)
{
	if( is_user_alive(iPlrId) && is_user_connected(iPlrId) )
		g_bAlive[iPlrId] = true;
}

public Ham_Killed_player_Post(iPlrId)
{
	if( !is_user_alive(iPlrId) )
		g_bAlive[iPlrId] = false;
	
#if defined HOTVISION_RADAR
	if( task_exists(iPlrId) )
		remove_task(iPlrId);
#endif
	if( task_exists(iPlrId+32) )
		remove_task(iPlrId+32);
	if( task_exists(iPlrId+64) )
		remove_task(iPlrId+64);
	if( task_exists(iPlrId+96) )
		remove_task(iPlrId+96);
	if( task_exists(iPlrId+128) )
		remove_task(iPlrId+128);
}

public FM_StartFrame_Pre()
{
	static s_iPlrId;
	for( s_iPlrId=1; s_iPlrId<=g_iMaxPlayers; s_iPlrId++ )
		g_bUpdateData[s_iPlrId] = true;
}

public FM_AddToFullPack_Post(iEsHandle, iE, iEnt, iHost, iHostFlags, iPlayer, iPSet)
{
	if( g_bConnected[iHost] )
	{
		if( g_bUpdateData[iHost] )
		{
			g_bUpdateData[iHost] = false;
			
			if( g_bAlive[iHost] )
			{
				if( get_pdata_int(iHost, PDPlayerState, 5)&PDPlrStateNvg )
					g_bInNvg[iHost] = true;
				else
					g_bInNvg[iHost] = false;
			}
			else if( pev(iHost, pev_iuser1)==4 )
			{
				static s_iSpectatedPerson;
				s_iSpectatedPerson = pev(iHost, pev_iuser2);
				if( s_iSpectatedPerson>g_iMaxPlayers || s_iSpectatedPerson<=0 )
					g_bInNvg[iHost] = false;
				else if( !g_bAlive[s_iSpectatedPerson] )
				{
					if( get_pdata_int(s_iSpectatedPerson, PDPlayerState, 5)&PDPlrStateNvg )
						g_bInNvg[iHost] = true;
					else
						g_bInNvg[iHost] = false;
				}
				else
					g_bInNvg[iHost] = false;
			}
			else
				g_bInNvg[iHost] = false;
		}
		
		if( g_bInNvg[iHost] )
		{
			if( iPlayer )
			{
				set_hotvision_plr(iEsHandle);
				return FMRES_IGNORED;
			}
#if defined HOTVISION_MODELS || defined HOTVISION_WALLS
			if( get_es(iEsHandle, ES_RenderMode) || !pev_valid(iEnt) )
				return FMRES_IGNORED;
			
			static s_iModel[2];
			pev(iEnt, pev_model, s_iModel, 1);
#endif
#if defined HOTVISION_MODELS
			if( s_iModel[0]=='m' )
			{
				set_hotvision_object(iEsHandle);
				return FMRES_IGNORED;
			}
#endif
#if defined HOTVISION_WALLS
			if( s_iModel[0]=='*' )
			{
				set_hotvision_walls(iEsHandle);
				return FMRES_IGNORED;
			}
#endif
		}
	}
	
	return FMRES_IGNORED;
}

public Event_ResetHUD(iPlrId)
{
	if( g_bAlive[iPlrId] )
	{
		if( get_pdata_int(iPlrId, PDPlayerState, 5)&PDPlrStateNvg )
		{
			new iTaskId = (iPlrId+32);
			if( task_exists(iTaskId) )
				remove_task(iTaskId);
			set_task(0.1, "send_nvg_msg", iTaskId);
			
			iTaskId += 32;
			if( task_exists(iTaskId) )
				remove_task(iTaskId);
			set_task(0.2, "send_nvg_msg", iTaskId);
			
			iTaskId += 32;
			if( task_exists(iTaskId) )
				remove_task(iTaskId);
			set_task(0.3, "send_nvg_msg", iTaskId);
			
			iTaskId += 32;
			if( task_exists(iTaskId) )
			{
				send_nvg_msg(iTaskId);
				remove_task(iTaskId);
			}
			set_task(0.4, "send_nvg_msg", iTaskId);
		}
	}
	else if( pev(iPlrId, pev_iuser1)==4 )
	{
		new iSpectatedPerson = pev(iPlrId, pev_iuser2);
		if( iSpectatedPerson>g_iMaxPlayers || iSpectatedPerson<=0 )
			return;
		else if( !g_bAlive[iSpectatedPerson] )
			return;
		else if( get_pdata_int(iSpectatedPerson, PDPlayerState, 5)&PDPlrStateNvg )
		{
			new iTaskId = (iPlrId+32);
			if( task_exists(iTaskId) )
			{
				send_nvg_msg(iTaskId);
				remove_task(iTaskId);
			}
			set_task(0.1, "send_nvg_msg", iTaskId);
			
			iTaskId += 32;
			if( task_exists(iTaskId) )
				remove_task(iTaskId);
			set_task(0.2, "send_nvg_msg", iTaskId);
			
			iTaskId += 32;
			if( task_exists(iTaskId) )
				remove_task(iTaskId);
			set_task(0.3, "send_nvg_msg", iTaskId);
			
			iTaskId += 32;
			if( task_exists(iTaskId) )
				remove_task(iTaskId);
			set_task(0.4, "send_nvg_msg", iTaskId);
		}
	}
}

public send_nvg_msg(iTaskId)
{
	new iPlrId = (((iTaskId-1)%32)+1);
	
	if( g_bAlive[iPlrId] )
	{
		if( !(get_pdata_int(iPlrId, PDPlayerState, 5)&PDPlrStateNvg) )
			return;
	}
	else if( pev(iPlrId, pev_iuser1)==4 )
	{
		new iSpectated = pev(iPlrId, pev_iuser2);
		
		if( iSpectated>g_iMaxPlayers || iSpectated<=0 )
			return;
		
		if( !g_bAlive[iSpectated] || !(get_pdata_int(iSpectated, PDPlayerState, 5)&PDPlrStateNvg) )
			return;
	}
	else
		return;
	
	message_begin(MSG_ONE_UNRELIABLE, g_iMsgId_NVGToggle, _, iPlrId);
	write_byte(1);
	message_end();
}

#if defined HOTVISION_RADAR
public Event_NVGToggle(iPlrId)
{
	if( read_data(1) )
	{
		if( !task_exists(iPlrId) )
			set_task(2.0, "refresh_radar", iPlrId, "", 0, "b");
	}
	else if( task_exists(iPlrId) )
		remove_task(iPlrId);
}

public refresh_radar(iPlrId)
{
	if( g_bConnected[iPlrId] && g_bAlive[iPlrId] )
	{
		if( get_pdata_int(iPlrId, PDPlayerState, 5)&PDPlrStateNvg )
		{
			new iTeam = get_user_team(iPlrId);
			new Float:fOrigin[3];
#if defined RADAR_DISTANCE
			new Float:fMainOrigin[3];
			pev(iPlrId, pev_origin, fMainOrigin);
#endif
			
			for( new iEnemyId=1; iEnemyId<=g_iMaxPlayers; iEnemyId++ )
			{
				if( iEnemyId!=iPlrId && g_bConnected[iEnemyId] && g_bAlive[iEnemyId] && iTeam!=get_user_team(iEnemyId) )
				{
					pev(iEnemyId, pev_origin, fOrigin);
#if defined RADAR_DISTANCE
					if( get_distance_f(fMainOrigin, fOrigin)>g_fRadarRange )
						continue;
#endif
					message_begin(MSG_ONE_UNRELIABLE, g_iMsgId_HostagePos, _, iPlrId);
					write_byte(1);
					write_byte((RADARID_OFFSET+iEnemyId));
					engfunc(EngFunc_WriteCoord, fOrigin[0]);
					engfunc(EngFunc_WriteCoord, fOrigin[1]);
					engfunc(EngFunc_WriteCoord, fOrigin[2]);
					message_end();
					
					message_begin(MSG_ONE_UNRELIABLE, g_iMsgId_HostageK, _, iPlrId);
					write_byte((RADARID_OFFSET+iEnemyId));
					message_end();
				}
			}
			
			return;
		}
	}
	
	remove_task(iPlrId);
}
#endif

set_hotvision_plr(iEsHandle)
{
	set_es(iEsHandle, ES_RenderMode, kRenderTransAdd);
	set_es(iEsHandle, ES_RenderAmt, 255);
	set_es(iEsHandle, ES_RenderFx, kRenderFxFadeSlow);
	set_es(iEsHandle, ES_RenderColor, {0, 0, 0});
}

#if defined HOTVISION_MODELS
set_hotvision_object(iEsHandle)
{
	set_es(iEsHandle, ES_RenderMode, kRenderTransAdd);
	set_es(iEsHandle, ES_RenderAmt, 255);
	set_es(iEsHandle, ES_RenderFx, kRenderFxDistort);
	set_es(iEsHandle, ES_RenderColor, {0, 0, 0});
}
#endif

#if defined HOTVISION_WALLS
set_hotvision_walls(iEsHandle)
{
	set_es(iEsHandle, ES_RenderMode, kRenderTransTexture);
	set_es(iEsHandle, ES_RenderAmt, 95);
	set_es(iEsHandle, ES_RenderFx, kRenderFxNone);
	set_es(iEsHandle, ES_RenderColor, {0, 0, 0});
}
#endif


// "plugins by numb" feature

new Array:g_aPBNSelections; // 128
new Array:g_aPBNLinks; // 1024
new g_iNumbsPluginsNum;
new g_iMenuPagePBN[33];
new bool:g_bSpawnedPBN[33];

public pl_by_numb_init()
{
	new iCvarNumbsPlugins = get_cvar_pointer("plugins_by_numb");
	if( pbn_should_we_register_stuff(iCvarNumbsPlugins) )
	{
		register_event("TextMsg",  "PBN_Joined",  "a", "1=1", "2=#Game_connected");
		register_event("ResetHUD", "PBN_Spawned", "be");
		
		if( !iCvarNumbsPlugins )
			iCvarNumbsPlugins = register_cvar("plugins_by_numb", "0", (FCVAR_SERVER|FCVAR_EXTDLL|FCVAR_SPONLY));
		set_pcvar_num(iCvarNumbsPlugins, PLUGIN_PBNID);
		
		register_menucmd(register_menuid("Plugins By Numb"), 1023, "Menu_Select_NumbsPlugins");
		register_clcmd("say /plugins_by_numb", "clcmd_numbsplugins");
		
		register_srvcmd("plugins_by_numb_add", "srvcmd_pluginsbynumb_add", ADMIN_RCON, "<menu interface> [web link] - add plugin to list");
		
		g_aPBNSelections = ArrayCreate(128);
		g_aPBNLinks    = ArrayCreate(1024);
	}
	else
		set_pcvar_num(iCvarNumbsPlugins, (get_pcvar_num(iCvarNumbsPlugins)|PLUGIN_PBNID));
}

bool:pbn_should_we_register_stuff(iCvarNumbsPlugins)
{
	if( !iCvarNumbsPlugins )
		return true;
	
	new iCvarValue = get_pcvar_num(iCvarNumbsPlugins);
	if( !iCvarValue )
		return true;
	else if( iCvarValue&PLUGIN_PBNID )
		return true;
	
	return false;
}

public pl_by_numb_cfg()
{
	new iData[128]
	new iLen = formatex(iData, 127, "\w%s \y%s", PLUGIN_NAME, PLUGIN_VERSION);
	
#if defined HOTVISION_MODELS
 #define PL_INFO_EDITED
	iLen += copy(iData[iLen], 127, " \d(\robjects");
#endif
	
#if defined HOTVISION_WALLS
 #if !defined PL_INFO_EDITED
  #define PL_INFO_EDITED
	iLen += copy(iData[iLen], 127-iLen, " \d(\ri-red");
 #else
	iLen += copy(iData[iLen], 127-iLen, " + i-red");
 #endif
#endif
	
#if defined HOTVISION_RADAR
 #if defined RADAR_DISTANCE
  #if !defined PL_INFO_EDITED
   #define PL_INFO_EDITED
	iLen += formatex(iData[iLen], 127-iLen, " \d(\rradar %du", clamp(RADAR_DISTANCE, 128, 8192));
  #else
	iLen += formatex(iData[iLen], 127-iLen, " + radar %du", clamp(RADAR_DISTANCE, 128, 8192));
  #endif
 #else
  #if !defined PL_INFO_EDITED
   #define PL_INFO_EDITED
	iLen += copy(iData[iLen], 127-iLen, " \d(\rradar");
  #else
	iLen += copy(iData[iLen], 127-iLen, " + radar");
  #endif
 #endif
#endif

#if defined PL_INFO_EDITED
	formatex(iData[iLen], 63-iLen, "\d)");
#endif
	
	server_cmd("plugins_by_numb_add ^"%s^" ^"%s^"", iData, PLUGIN_LINK);
	server_print("--- Trying to add ^"%s^" plugin (version ^"%s^") to ^"plugins by Numb^" list ---", PLUGIN_NAME, PLUGIN_VERSION);
}

public PBN_Joined()
{
	new iName[32];
	read_data(3, iName, 31);
	static s_iMaxPlayers;
	if( !s_iMaxPlayers )
		s_iMaxPlayers = clamp(get_maxplayers(), 1, 32);
	
	new iConnectingName[32];
	for( new iPlrId=1; iPlrId<=s_iMaxPlayers; iPlrId++ )
	{
		if( is_user_connecting(iPlrId) )
		{
			get_user_info(iPlrId, "name", iConnectingName, 31);
			
			if( equal(iConnectingName, iName) )
			{
				g_bSpawnedPBN[iPlrId] = false;
				break;
			}
		}
	}
}

public PBN_Spawned(iPlrId)
{
	if( g_bSpawnedPBN[iPlrId] || is_user_connecting(iPlrId) )
		return;
	
	g_bSpawnedPBN[iPlrId] = true;
	
	static s_iMsgId_SayText;
	if( !s_iMsgId_SayText )
		s_iMsgId_SayText = get_user_msgid("SayText");
	
	message_begin(MSG_ONE_UNRELIABLE, s_iMsgId_SayText, _, iPlrId);
	write_byte(iPlrId);
	write_string("^x03* ^x01To see some plugins what effect game-play please type ^"^x04/plugins_by_numb^x01^" in chat.");
	message_end();
}

public srvcmd_pluginsbynumb_add()
{
	new iMenuInterface[128];
	if( !read_argv(1, iMenuInterface, 127) )
	{
		server_print("Usage:  plugins_by_numb_add <menu interface> [web link] - add plugin to list");
		return PLUGIN_HANDLED;
	}
	
	new iWebLink[1024];
	read_argv(2, iWebLink, 1023);
	
	ArrayPushString(g_aPBNSelections, iMenuInterface);
	ArrayPushString(g_aPBNLinks,      iWebLink);
	g_iNumbsPluginsNum++;
	
	server_print("--- Plugin with ^"%s^" link successfully added to ^"plugins by Numb^" list ---", iWebLink);
	
	return PLUGIN_HANDLED;
}

public clcmd_numbsplugins(iPlrId)
{
	g_iMenuPagePBN[iPlrId] = 0;
	Menu_Open_PBN(iPlrId);
}

Menu_Open_PBN(iPlrId)
{
	new iMenuBody[512], iMenuBody_len, iKeys = MENU_KEY_0;
	
	new iMaxPages = (g_iNumbsPluginsNum/7);
	if( g_iNumbsPluginsNum%7 || !iMaxPages )
		iMaxPages++;
	
	if( g_iMenuPagePBN[iPlrId]>=iMaxPages )
	{
		log_amx("ERROR: [part1/3] Invalid page selection (#%d - max pages %d) in ^"plugins by Numb^" list.", g_iMenuPagePBN[iPlrId], iMaxPages);
		log_amx("ERROR: [part2/3] I warned not to mess around with this system. Lets see if you'll get real errors now.");
		log_amx("ERROR: [part3/3] If you wont get any errors than know that there is a 50/50 possibility that motd-window links do not match the plugins.");
		g_iMenuPagePBN[iPlrId] = (iMaxPages-1);
	}
	else if( g_iMenuPagePBN[iPlrId]<0 )
	{
		log_amx("ERROR: [part1/3] Invalid page selection (#%d - min pages 1) in ^"plugins by Numb^" list.", (g_iMenuPagePBN[iPlrId]+1));
		log_amx("ERROR: [part2/3] I warned not to mess around with this system. Lets see if you'll get real errors now.");
		log_amx("ERROR: [part3/3] If you wont get any errors than know that there is a 50/50 possibility that motd-window links do not match the plugins.");
		g_iMenuPagePBN[iPlrId] = 0;
	}
	
	new bool:bNextPageValid;
	new iSelectionStart = (g_iMenuPagePBN[iPlrId]*7);
	new iSelectionEnd = (iSelectionStart+7);
	if( iSelectionEnd>g_iNumbsPluginsNum )
		iSelectionEnd = g_iNumbsPluginsNum;
	else
		bNextPageValid = (iSelectionEnd==g_iNumbsPluginsNum)?false:true;
	
	new iSelectionsInThisPage = (iSelectionEnd-iSelectionStart);
	
	
	iMenuBody_len = formatex(iMenuBody, 511, "\yPlugins by Numb\R\d)\r%d\y/\r%d\d(^n", iMaxPages, (g_iMenuPagePBN[iPlrId]+1));
	
	new iMotdMsg[1024], iArrayId;
	for( new iSelectionId; iSelectionId<iSelectionsInThisPage; iSelectionId++ )
	{
		iArrayId = (iSelectionId+iSelectionStart);
		
		iMotdMsg[0] = 0;
		ArrayGetString(g_aPBNLinks, iArrayId, iMotdMsg, 1023);
		
		if( iMotdMsg[0] )
		{
			iMenuBody_len += formatex(iMenuBody[iMenuBody_len], 511-iMenuBody_len, "^n\r%d\y. %a", (iSelectionId+1), ArrayGetStringHandle(g_aPBNSelections, iArrayId));
			iKeys |= (1<<iSelectionId);
		}
		else
			iMenuBody_len += formatex(iMenuBody[iMenuBody_len], 511-iMenuBody_len, "^n\d- \r%d\y. %a", (iSelectionId+1), ArrayGetStringHandle(g_aPBNSelections, iArrayId));
	}
	
	if( g_iMenuPagePBN[iPlrId] )
	{
		iMenuBody_len += copy(iMenuBody[iMenuBody_len], 511-iMenuBody_len, "^n^n\r8\y. \wBack");
		iKeys |= MENU_KEY_8;
	}
	else
		iMenuBody_len += copy(iMenuBody[iMenuBody_len], 511-iMenuBody_len, "^n^n\r8\y. \dBack");
	
	if( bNextPageValid )
	{
		iMenuBody_len += copy(iMenuBody[iMenuBody_len], 511-iMenuBody_len, "^n\r9\y. \wNext");
		iKeys |= MENU_KEY_9;
	}
	else
		iMenuBody_len += copy(iMenuBody[iMenuBody_len], 511-iMenuBody_len, "^n\r9\y. \dNext");
	
	iMenuBody_len += formatex(iMenuBody[iMenuBody_len], 511-iMenuBody_len, "^n^n\r0\y. \wExit");
	
	show_menu(iPlrId, iKeys, iMenuBody, -1, "Plugins By Numb");
}

public Menu_Select_NumbsPlugins(iPlrId, iKey)
{
	switch( iKey )
	{
		case 7:
		{
			g_iMenuPagePBN[iPlrId]--;
			Menu_Open_PBN(iPlrId);
			
			return PLUGIN_HANDLED;
		}
		case 8:
		{
			g_iMenuPagePBN[iPlrId]++;
			Menu_Open_PBN(iPlrId);
			
			return PLUGIN_HANDLED;
		}
		case 9: return PLUGIN_HANDLED;
	}
	
	Menu_Open_PBN(iPlrId);
	
	new iSelection = (iKey+(g_iMenuPagePBN[iPlrId]*7));
	if( iSelection>=g_iNumbsPluginsNum )
	{
		log_amx("ERROR: [part1/3] Invalid menu selection (#%d - plugins included %d) in ^"plugins by Numb^" list.", (iSelection+1), g_iNumbsPluginsNum);
		log_amx("ERROR: [part2/3] I warned not to mess around with this system. Lets see if you'll get real errors now.");
		log_amx("ERROR: [part3/3] If you wont get any errors than know that there is a 50/50 possibility that motd-window links do not match the plugins.");
		
		return PLUGIN_CONTINUE;
	}
	else
	{
		new iWebLink[1024];
		ArrayGetString(g_aPBNLinks, iSelection, iWebLink, 1023);
		client_print(iPlrId, print_console, "* This plugin can be found here: %s", iWebLink);
		client_print(iPlrId, print_chat, "* This plugin can be found here: %s", iWebLink);
		show_motd(iPlrId, iWebLink, "Plugins By Numb");
	}
	
	return PLUGIN_HANDLED;
}
