/* AMX Mod script.
*
* Disco Mode
*  by SniperBeamer
*
*
* Description:
*  All players are glowing and the screen fades.
*  It's not recommend to use low switch time values.
* Usage:
*  amx_disco <switch time> (min 0.1)
* Examples:
*  amx_disco 1.0 (change colors every second)
*  amx_disco 0 (off)
*
*/

//----------------------------------------------------------------------------------------------
#include <amxmod>
#include <amxmisc>
#include <fun>
//----------------------------------------------------------------------------------------------
#define COLORS 6
//----------------------------------------------------------------------------------------------
new colors[COLORS][3] = {{255,0,0},{0,255,0},{0,0,255},{255,255,0},{255,0,255},{0,255,255}}
new gmsgFade
new bool:disco = false
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	register_plugin("Disco Mode","0.1","SniperBeamer")
	register_concmd("amx_disco","disco_switch",ADMIN_LEVEL_D,"<switch time>")
	gmsgFade = get_user_msgid("ScreenFade")
}
//----------------------------------------------------------------------------------------------
public disco_switch(id,level,cid)
{
	if (!cmd_access(id,level,cid,1))
		return PLUGIN_HANDLED

	new arg[32]
	read_argv(1,arg,31)
	new Float:switch_time = floatstr(arg)

	if (switch_time>0 && !equal(arg,""))
	{
		disco = true
		set_hudmessage(255,50,0,-1.0,0.25,2,3.0,15.0,0.3,0.2,5)
		show_hudmessage(0,"Disco Mode is ON")
		remove_task(576001)
		remove_task(576002)
		disco_glow()
		disco_fade()
		set_task(switch_time,"disco_glow",576001,"",0,"b")
		set_task(switch_time,"disco_fade",576002,"",0,"b")
	}
	else if (switch_time==0 && !equal(arg,"") && disco)
	{
		disco = false
		set_hudmessage(255,50,0,-1.0,0.25,2,3.0,10.0,0.3,0.2,5)
		show_hudmessage(0,"Disco Mode is OFF")
		remove_task(576001)
		remove_task(576002)
		disco_glow_off()
		disco_fade_off()
	}
	console_print(id,"[AMX] Disco is %s",(disco)?"on":"off")

	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
public disco_glow()
{
	new plist[32],pnum,ran
	get_players(plist,pnum,"a")
	for (new i=0; i<pnum; i++)
	{
		ran = random_num(0,COLORS-1)
		set_user_rendering(plist[i],kRenderFxGlowShell,colors[ran][0],colors[ran][1],colors[ran][2],kRenderTransAlpha,220)
	}
}
//----------------------------------------------------------------------------------------------
public disco_fade()
{
	new plist[32],pnum,ran = random_num(0,COLORS-1)
	get_players(plist,pnum,"c")
	for (new i=0; i<pnum; i++)
	{
		message_begin(MSG_ONE,gmsgFade,{0,0,0},plist[i])
		write_short( 1<<0 ) // fade lasts this long duration
		write_short( 1<<0 ) // fade lasts this long hold time
		write_short( 1<<2 ) // fade type (in / out)
		write_byte( colors[ran][0] ) // fade red
		write_byte( colors[ran][1] ) // fade green
		write_byte( colors[ran][2] ) // fade blue
		write_byte( 100 ) // fade alpha
		message_end()
	}
}
//----------------------------------------------------------------------------------------------
public disco_glow_off()
{
	new plist[32],pnum
	get_players(plist,pnum)
	for (new i=0; i<pnum; i++)
		set_user_rendering(plist[i],kRenderFxGlowShell,0,0,0,kRenderTransAlpha,255)
}
//----------------------------------------------------------------------------------------------
public disco_fade_off()
{
	new plist[32],pnum
	get_players(plist,pnum,"c")
	for (new i=0; i<pnum; i++)
	{
		message_begin(MSG_ONE,gmsgFade,{0,0,0},plist[i])
		write_short( 1<<1 ) // fade lasts this long duration
		write_short( 1<<1 ) // fade lasts this long hold time
		write_short( 1<<12 ) // fade type (in / out)
		write_byte( 0 ) // fade red
		write_byte( 0 ) // fade green
		write_byte( 0 ) // fade blue
		write_byte( 0 ) // fade alpha
		message_end()
	}
}
//----------------------------------------------------------------------------------------------
