// Includes
#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <hamsandwich>

// Pragma
#pragma semicolon 1

// Plugin info
new const PLUGIN[] =	"Surf Main Points";
new const VERSION[] =	"1.0";
new const AUTHOR[] =	"Hattrick";

/*************************************************
***************** [ Customization ] *******************
**************************************************
	---===[[[ You can choose only one! ]]]===---
**************************************************/

///////#define STEAM
#define NICK
///////#define IP


// Spectator target
const PEV_SPEC_TARGET = pev_iuser2;

// Bool
new g_Points[33];

// Hudmessage
new g_HudSterVVVXXXxyz;

// Init
public plugin_init()
{
	// Register the plugin
	register_plugin(PLUGIN, VERSION, AUTHOR);
	
	// Register the events
	register_event("ResetHUD", "event_ResetHud", "be");
	
	// Forwards
	RegisterHam(Ham_Killed, "player", "ham_PlayerKilled");
	RegisterHam(Ham_Spawn, "player", "ham_PlayerSpawned_Post", 1);
	
	// Hudmessage
	g_HudSterVVVXXXxyz = CreateHudSyncObj();
}

// Register natives
public plugin_natives()
{
	register_native("surf_get_user_points", "native_get_user_points", 1);
	register_native("surf_set_user_points", "native_set_user_points", 1);
	register_native("surf_add_user_points", "native_add_user_points", 1);
	register_native("surf_del_user_points", "native_del_user_points", 1);
}

// When player died
public ham_PlayerKilled(victim, attacker)
{
	static selfkill;
	selfkill = (victim == attacker || !is_user_connected(attacker)) ? true : false;
	if (!selfkill)
	{
		g_Points[attacker]++;
	}
}

// After player spawns
public ham_PlayerSpawned_Post(id)
{
	if (is_user_connected(id) && is_user_alive(id))
	{
		set_task(1.0, "ShowHud", id, _, _, "b");
	}
}

// Resethud Event
public event_ResetHud(id)
{
	ShowHud(id);
}

// Show Hud function
public ShowHud(id)
{
	if (is_user_connected(id) && is_user_alive(id) && (get_user_team(id) == 1 || get_user_team(id) == 2))
	{
		set_hudmessage(60, 60, 60, 0.01, 0.23, 0, 0.5, 15.0, 2.0, 2.0, -1);
		ShowSyncHudMsg(id, g_HudSterVVVXXXxyz, "Health: %d^nPoints: %d", get_user_health(id), g_Points[id]);
	}
	else
	{
		new idSpec;
		new iPlayerName[32];
		idSpec = pev(id, PEV_SPEC_TARGET);
		get_user_name(idSpec, iPlayerName, 31);
		set_hudmessage(60, 60, 60, 0.01, 0.22, 0, 0.5, 15.0, 2.0, 2.0, -1);
		ShowSyncHudMsg(id, g_HudSterVVVXXXxyz, "Spectating: %s^nHealth: %d^nPoints: %d", iPlayerName, get_user_health(idSpec), g_Points[idSpec]);
	}
}

// Save data function
public SaveData(id)
{
	#if defined STEAM
	new steamid[35];
	get_user_authid(id, steamid, 34);
	new vaultkey[64], vaultdata[328];
	format(vaultkey, 63, "SURFS_%s", steamid);
	format(vaultdata, 327, "%i#", g_Points[id]);
	set_vaultdata(vaultkey, vaultdata);
	#endif
	
	#if defined NICK
	new name[35];
	get_user_name(id, name, 34);
	new vaultkey[64], vaultdata[328];
	format(vaultkey, 63, "SURFS_%s", name);
	format(vaultdata, 327, "%i#", g_Points[id]);
	set_vaultdata(vaultkey, vaultdata);
	#endif
	
	#if defined IP
	new ip[35];
	get_user_ip(id, ip, 34, 1);
	new vaultkey[64], vaultdata[328];
	format(vaultkey, 63, "SURFS_%s", name);
	format(vaultdata, 327, "%i#", g_Points[id]);
	set_vaultdata(vaultkey, vaultdata);
	#endif
}

// Load data function
public LoadData(id)
{
	#if defined STEAM
	new steamid[35];
	get_user_authid(id, steamid, 34);
	new vaultkey[64], vaultdata[328];
	format(vaultkey, 63, "SURFS_%s", steamid);
	format(vaultdata, 327, "%i#", g_Points[id]);
	get_vaultdata(vaultkey, vaultdata, 327);
	replace_all(vaultdata, 327, "#", " ");
	new g_point[32];
	parse(vaultdata, g_point, 31);
	g_Points[id] = str_to_num(g_point);
	#endif
	
	#if defined NICK
	new name[35];
	get_user_name(id, name, 34);
	new vaultkey[64], vaultdata[328];
	format(vaultkey, 63, "SURFS_%s", name);
	format(vaultdata, 327, "%i#", g_Points[id]);
	get_vaultdata(vaultkey, vaultdata, 327);
	replace_all(vaultdata, 327, "#", " ");
	new g_point[32];
	parse(vaultdata, g_point, 31);
	g_Points[id] = str_to_num(g_point);
	#endif
	
	#if defined IP
	new ip[35];
	get_user_ip(id, ip, 34, 1);
	new vaultkey[64], vaultdata[328];
	format(vaultkey, 63, "SURFS_%s", ip);
	format(vaultdata, 327, "%i#", g_Points[id]);
	get_vaultdata(vaultkey, vaultdata, 327);
	replace_all(vaultdata, 327, "#", " ");
	new g_point[32];
	parse(vaultdata, g_point, 31);
	g_Points[id] = str_to_num(g_point);
	#endif
}

// Plugin natives
// Native: surf_get_user_points
public native_get_user_points(id)
{
	return g_Points[id];
}

// Native: surf_set_user_points
public native_set_user_points(id, amount)
{
	g_Points[id] = amount;
}

// Native: surf_add_user_points
public native_add_user_points(id, amount)
{
	g_Points[id] += amount;
}

// Native: surf_del_user_points
public native_del_user_points(id, amount)
{
	g_Points[id] -= amount;
}

// When client enter on server
public client_putinserver(id)
{
	LoadData(id);
}

// When client disconnect
public client_disconnect(id)
{
	SaveData(id);
}