// Includes
#include <amxmodx>
#include <amxmisc>
#include <surf>

// Pragma
#pragma semicolon 1

// Plugin info
new const PLUGIN[] =	"Surf Points Manager";
new const VERSION[] =	"1.0";
new const AUTHOR[] =	"Hattrick";

// Customization
new const xPrefix[] =	"!g[Surf Points Manager]";
new const xLogFile[] = "surf_points_manager.log";

// Init
public plugin_init()
{
	// Register the plugin
	register_plugin(PLUGIN, VERSION, AUTHOR);
	
	// Register the plugin dictionary
	register_dictionary("surf_points_manager.txt");
	
	// Admin commands
	register_concmd("amx_give_points", "command_GivePoints", ADMIN_LEVEL_C, "<^"name^" or #userid> <amount>");
	register_concmd("amx_remove_points", "command_RemovePoints", ADMIN_LEVEL_C, "<^"name^" or #userid> <amount>");
}

// Give points command
public command_GivePoints(id, level, cid)
{
	if (!cmd_access(id, level, cid, 2))
	{
		return PLUGIN_HANDLED;
	}
	new arg[32], arg2[6];
	read_argv(1, arg, 31);
	read_argv(2, arg2, 5);
	new target = cmd_target(id, arg, CMDTARGET_ALLOW_SELF | CMDTARGET_NO_BOTS);
	if (!target)
	{
		return PLUGIN_HANDLED;
	}
	new points;
	points = str_to_num(arg2);
	surf_add_user_points(target, points);
	new name[32], name2[32];
	get_user_name(id, name, 31);
	get_user_name(target, name2, 31);
	log_to_file(xLogFile, "%L", LANG_SERVER, "SURF_LOG_GIVE", name, points, name2);
	write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_GIVE_ANNOUNCE", name, points, name2);
	return PLUGIN_HANDLED;
}

// Remove points command
public command_RemovePoints(id, level, cid)
{
	if (!cmd_access(id, level, cid, 2))
	{
		return PLUGIN_HANDLED;
	}
	new arg[32], arg2[6];
	read_argv(1, arg, 31);
	read_argv(2, arg2, 5);
	new target = cmd_target(id, arg, CMDTARGET_ALLOW_SELF | CMDTARGET_NO_BOTS);
	if (!target)
	{
		return PLUGIN_HANDLED;
	}
	new points;
	points = str_to_num(arg2);
	surf_del_user_points(target, points);
	new name[32], name2[32];
	get_user_name(id, name, 31);
	get_user_name(target, name2, 31);
	log_to_file(xLogFile, "%L", LANG_SERVER, "SURF_LOG_REMOVE", name, points, name2);
	write_colored(0, "%s %L", xPrefix, LANG_PLAYER, "SURF_REMOVE_ANNOUNCE", name, points, name2);
	return PLUGIN_HANDLED;
}

// Write colored function
public write_colored(const id, const string[], {Float, Sql, Resul,_}:...)
{
	new msg[191], players[32], count = 1;
	vformat(msg, 190, string, 3);
	replace_all(msg, 190, "!n", "^1");
	replace_all(msg, 190, "!t", "^3");
	replace_all(msg, 190, "!g", "^4");
	if (id) players[0] = id;
	else get_players(players, count, "ch");
	for (new i = 0; i < count; i++)
	{
		if (is_user_connected(players[i]))
		{
			message_begin(MSG_ONE_UNRELIABLE, get_user_msgid("SayText"), _, players[i]);
			write_byte(players[i]);
			write_string(msg);
			message_end();
		}
	}
}