
#include amxmodx
#include xs
#include fakemeta
#include hamsandwich

#define	MinDist 100.0
#define	MaxDist 500.0
#define	ChangMoveDist 10.0

new GibsModel
new DustSprite
new mapname[32]
new mapfile[64]
new EntMove[33]
new EntThrow[33]
new bool:IsMove[33]
new Float:fMoveDistance[33]
new bool:IsChageDistBack[33]
new Float:fBoxCenterZ = 21.61
new bool:IsChageDistForward[33]
new Float:fBoxMaxs[3] = {21.72, 21.72, 43.21}
new Float:fBoxMins[3] = {-21.72, -21.72, 0.01}

new breakable_sound[3][] = {
	"debris/bustcrate1.wav",
	"debris/bustcrate2.wav",
	"debris/bustcrate3.wav"
}

new damage_sound[3][] = {
	"debris/wood1.wav",
	"debris/wood2.wav",
	"debris/wood3.wav"
}

new other_sound[3][] = {
	"items/box_move_on.wav",
	"items/box_move_off.wav",
	"items/box_warning.wav"
}

public plugin_init() {
	get_mapname(mapname, 31)
	register_cvar("box_health", "300")
	register_concmd("box_use", "box_use")
	register_concmd("box_throw", "box_throw")
	register_concmd("box_create", "box_create")
	RegisterHam(Ham_Spawn, "player", "fw_spawn")
	format(mapfile, 63, "maps/%s_boxes.cfg",mapname)
	RegisterHam(Ham_Touch, "info_target", "fw_touch")
	RegisterHam(Ham_Think, "info_target", "fw_think")
	RegisterHam(Ham_Killed, "info_target", "fw_killed")
	register_concmd("box_delete_all", "box_delete_all")
	register_concmd("box_create_exec", "box_create_exec")
	register_concmd("box_save_mapfile", "box_save_mapfile")
	register_concmd("box_load_mapfile", "box_load_mapfile")
	register_concmd("box_reload_mapfile", "box_reload_mapfile")
	register_concmd("box_delete_mapfile", "box_delete_mapfile")
	register_concmd("box_delete_current", "box_delete_current")
	RegisterHam(Ham_TakeDamage, "info_target", "fw_takedamage")
	register_concmd("box_delete_all_saved", "box_delete_all_saved")
	register_concmd("+box_movedist_back", "box_movedist_back_plus")
	register_concmd("-box_movedist_back", "box_movedist_back_minus")
	register_concmd("+box_movedist_forward", "box_movedist_forward_plus")
	register_concmd("-box_movedist_forward", "box_movedist_forward_minus")
	if(get_user_msgid("HLTV") > 0) 
		register_event("HLTV", "event_hltv", "a", "1=0", "2=0")
	if(file_exists(mapfile)) 
		server_cmd("exec %s",mapfile)
	register_plugin("Box Creator", "1.0", "PahanCS")
}

public plugin_precache() {
	precache_model("models/box.mdl")
	GibsModel = precache_model("models/box_gibs.mdl")
	DustSprite = precache_model("sprites/box_dust.spr")
	for(new i=0; i<3; i++) {
		precache_sound(breakable_sound[i])
		precache_sound(damage_sound[i])
		precache_sound(other_sound[i])
	}
}

public fw_spawn(id) {
	if(is_user_alive(id)) {
		static ent
		ent = get_moving_box(id)
		if(pev_valid(ent)) 
			fm_set_rendering(ent, kRenderFxNone, 0, 0, 0, kRenderNormal, 0)
		set_moving_box(id, 0)
		IsMove[id] = false
		ent = get_throwing_box(id)
		if(pev_valid(ent)) 
			set_thrower_box(ent, 0)
		set_throwing_box(id, 0)
	}
	return HAM_IGNORED
}

public fw_touch(ent, idother) {
	if(!is_entity_box_breakable(ent) || idother < 0 || pev(idother, pev_solid) < SOLID_BBOX) 
		return HAM_IGNORED
	static attacker
	attacker = get_thrower_box(ent)
	if(!is_user_connected(attacker) || attacker == idother) 
		return HAM_IGNORED
	static Float:fVelocity[3], Float:fLength
	pev(ent, pev_velocity, fVelocity)
	fLength = vector_length(fVelocity)
	if(fLength < 300.0) {
		set_thrower_box(ent, 0)
		set_throwing_box(attacker, 0)
		return HAM_IGNORED
	}
	fLength /= 10.0
	if(is_user_connected(idother)) {
		if(get_user_team(attacker) != get_user_team(idother)) 
			ExecuteHamB(Ham_TakeDamage, idother, attacker, attacker, fLength / 2, DMG_GENERIC)
		else 
			ExecuteHamB(Ham_TakeDamage, idother, attacker, attacker, fLength, DMG_GENERIC)
	}
	else if(is_damaging_entity(idother)) 
		ExecuteHamB(Ham_TakeDamage, idother, attacker, attacker, fLength, DMG_GENERIC)
	set_thrower_box(ent, 0)
	set_throwing_box(attacker, 0)
	ExecuteHamB(Ham_TakeDamage, ent, attacker, attacker, fLength, DMG_GENERIC)
	return HAM_IGNORED
}

public fw_think(ent) {
	if(!is_entity_box_breakable(ent)) 
		return HAM_IGNORED
	static idmover
	idmover = get_mover_box(ent)
	if(!is_user_alive(idmover)) {
		if(idmover) {
			set_mover_box(ent, 0)
			fm_set_rendering(ent, kRenderFxNone, 0, 0, 0, kRenderNormal, 0)
			if(is_normal_index(idmover)) {
				set_moving_box(idmover, 0)
				IsMove[idmover] = false
			}
		}
		if(pev(ent, pev_flags) & FL_ONGROUND && fm_distance_to_floor(ent) > 0.0) {
			static Float:fEntVelocity[3]
			fEntVelocity[0] = 0.0; fEntVelocity[1] = 0.0
			fEntVelocity[2] = -8191.0
			set_pev(ent, pev_velocity, fEntVelocity)
		}
		set_pev(ent, pev_nextthink, get_gametime() + 0.1)
		return HAM_IGNORED
	}
	if(!IsMove[idmover]) {
		set_moving_box(idmover, 0)
		set_mover_box(ent, 0)
		fm_set_rendering(ent, kRenderFxNone, 0, 0, 0, kRenderNormal, 0)
		set_pev(ent, pev_nextthink, get_gametime() + 0.1)
		return HAM_IGNORED
	}
	if(IsChageDistForward[idmover]) {
		fMoveDistance[idmover] += ChangMoveDist
		if(fMoveDistance[idmover] > MaxDist) {
			fMoveDistance[idmover] = MaxDist
		}
	}
	else if(IsChageDistBack[idmover]) {
		fMoveDistance[idmover] -= ChangMoveDist
		if(fMoveDistance[idmover] < MinDist) {
			fMoveDistance[idmover] = MinDist
		}
	}
	static Float:fOrigin[3], Float:fAimOrigin[3], Float:fEntOrigin[3], 
	Float:fDirection[3], Float:fMoveto[3], Float:fVelocity[3], Float:fLength
	pev(idmover, pev_origin, fOrigin)
	fm_get_aimorigin_dist(idmover, MaxDist, fAimOrigin)
	pev(ent, pev_origin, fEntOrigin)
	fAimOrigin[2] -= fBoxCenterZ
	xs_vec_sub(fAimOrigin, fOrigin, fDirection)
	fLength = get_distance_f(fAimOrigin, fOrigin)
	if(fLength < 1.0) 
		fLength = 1.0
	fMoveto[0] = fOrigin[0] + fDirection[0] * fMoveDistance[idmover] / fLength
	fMoveto[1] = fOrigin[1] + fDirection[1] * fMoveDistance[idmover] / fLength
	fMoveto[2] = fOrigin[2] + fDirection[2] * fMoveDistance[idmover] / fLength
	fVelocity[0] = (fMoveto[0] - fEntOrigin[0]) * 8
	fVelocity[1] = (fMoveto[1] - fEntOrigin[1]) * 8
	fVelocity[2] = (fMoveto[2] - fEntOrigin[2]) * 8
	set_pev(ent, pev_velocity, fVelocity)
	set_pev(ent, pev_nextthink, get_gametime() + 0.1)
	return HAM_IGNORED
}

public fw_killed(ent, idattacker, shouldgib) {
	if(!is_entity_box_breakable(ent)) 
		return HAM_IGNORED
	static id,  Float:fEntOrigin[3]
	id = get_mover_box(ent)
	if(is_normal_index(id)) {
		set_moving_box(id, 0)
		IsMove[id] = false
	}
	id = get_thrower_box(ent)
	if(is_normal_index(id)) 
		set_throwing_box(id, 0)
	pev(ent, pev_origin, fEntOrigin)
	engfunc(EngFunc_EmitSound, ent, CHAN_AUTO, breakable_sound[random_num(0, 2)], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	create_dust(fEntOrigin)
	create_breakmodel(fEntOrigin)
	return HAM_IGNORED
}

public fw_takedamage(ent, idinflictor, idattacker, Float:damage, damagebits) {
	if(!is_entity_box_breakable(ent)) 
		return HAM_IGNORED
	static Float:fEntOrigin[3]
	pev(ent, pev_origin, fEntOrigin)
	if(is_inflictor_grenade(idinflictor) && damage <= 0.0) {
		static Float:fInfOrigin[3]
		pev(idinflictor, pev_origin, fInfOrigin)
		damage = 300.0 - (get_distance_f(fEntOrigin, fInfOrigin) - 130.0)
		SetHamParamFloat(4, damage > 0.0 ? damage:0.0)
		engfunc(EngFunc_EmitSound, ent, CHAN_AUTO, damage_sound[random_num(0, 2)], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		create_dust(fEntOrigin)
		box_push_from_grenade(ent, idinflictor, damage)
		return HAM_HANDLED
	}
	else if(is_user_connected(idattacker)) 
		box_push_from_attacker(ent, idattacker, damage)
	engfunc(EngFunc_EmitSound, ent, CHAN_AUTO, damage_sound[random_num(0, 2)], VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
	create_dust(fEntOrigin)
	return HAM_IGNORED
}

public event_hltv() {
	if(!file_exists(mapfile)) 
		return PLUGIN_CONTINUE
	static fb
	fb = engfunc(EngFunc_FindEntityByString, -1, "classname", "box_breakable")
	while(fb > 0) {
		if(pev_valid(fb) && is_saved_box(fb)) {
			static id
			id = get_mover_box(fb)
			if(is_normal_index(id)) {
				set_moving_box(id, 0)
				IsMove[id] = false
			}
			id = get_thrower_box(fb)
			if(is_normal_index(id)) 
				set_throwing_box(id, 0)
			engfunc(EngFunc_RemoveEntity, fb)
		}
		fb = engfunc(EngFunc_FindEntityByString, fb, "classname", "box_breakable")
	}
	server_cmd("exec %s",mapfile)
	return PLUGIN_CONTINUE
}

public box_use(id) {
	if(!IsMove[id]) {
		static ent
		ent = fm_get_aiment_dist(id, MaxDist)
		if(is_entity_box_breakable(ent) && get_mover_box(ent) < 1) {
			if(fMoveDistance[id] > MaxDist) 
				fMoveDistance[id] = MaxDist
			if(fMoveDistance[id] < MinDist) 
				fMoveDistance[id] = MinDist
			IsMove[id] = true
			fm_set_rendering(ent, kRenderFxNone, 10, 10, 255, kRenderTransColor, 100)
			set_thrower_box(ent, 0)
			set_moving_box(id, ent)
			set_mover_box(ent, id)
			client_cmd(id, "spk %s",other_sound[0])
		}
		else 
			client_cmd(id, "spk %s",other_sound[2])
	}
	else {
		static ent
		ent = get_moving_box(id)
		if(pev_valid(ent) && get_mover_box(ent) == id) {
			set_moving_box(id, 0)
			set_mover_box(ent, 0)
			fm_set_rendering(ent, kRenderFxNone, 0, 0, 0, kRenderNormal, 0)
			IsMove[id] = false
			client_cmd(id, "spk %s",other_sound[1])
		}
		else 
			client_cmd(id, "spk %s",other_sound[2])
	}
	return PLUGIN_CONTINUE
}

public box_throw(id) {
	if(!is_user_alive(id) || !IsMove[id]) {
		client_cmd(id, "spk %s",other_sound[2])
		return PLUGIN_CONTINUE
	}
	static ent
	ent = get_moving_box(id)
	if(pev_valid(ent) && get_mover_box(ent) == id) {
		fm_set_rendering(ent, kRenderFxNone, 0, 0, 0, kRenderNormal, 0)
		set_moving_box(id, 0)
		set_mover_box(ent, 0)
		IsMove[id] = false
		static Float:fThrowVelocity[3]
		get_throw_velocity(id, fThrowVelocity)
		set_pev(ent, pev_velocity, fThrowVelocity)
		set_throwing_box(id, ent)
		set_thrower_box(ent, id)
	}
	else 
		client_cmd(id, "spk %s",other_sound[2])
	return PLUGIN_CONTINUE
}

public box_movedist_back_plus(id) {
	if(!is_user_alive(id) || !IsMove[id]) {
		IsChageDistBack[id] = false
		client_cmd(id, "spk %s",other_sound[2])
		return PLUGIN_CONTINUE
	}
	IsChageDistBack[id] = true
	return PLUGIN_CONTINUE
}

public box_movedist_back_minus(id) {
	if(IsChageDistBack[id]) 
		IsChageDistBack[id] = false
	return PLUGIN_CONTINUE
}

public box_movedist_forward_plus(id) {
	if(!is_user_alive(id) || !IsMove[id]) {
		IsChageDistForward[id] = false
		client_cmd(id, "spk %s",other_sound[2])
		return PLUGIN_CONTINUE
	}
	IsChageDistForward[id] = true
	return PLUGIN_CONTINUE
}

public box_movedist_forward_minus(id) {
	if(IsChageDistForward[id]) 
		IsChageDistForward[id] = false
	return PLUGIN_CONTINUE
}

public box_create(id) {
	if(!is_user_alive(id) || IsMove[id]) {
		client_cmd(id, "spk %s",other_sound[2])
		return PLUGIN_CONTINUE
	}
	static Float:fEntOrigin[3]
	fm_get_aimorigin_dist(id, MinDist, fEntOrigin)
	fEntOrigin[2] -= fBoxCenterZ
	static ent
	ent = create_box(fEntOrigin)
	if(ent <= 0) {
		client_cmd(id, "spk %s",other_sound[2])
		return PLUGIN_CONTINUE
	}
	set_moving_box(id, ent)
	set_mover_box(ent, id)
	IsMove[id] = true
	if(fMoveDistance[id] > MaxDist) 
		fMoveDistance[id] = MaxDist
	if(fMoveDistance[id] < MinDist) 
		fMoveDistance[id] = MinDist
	fm_set_rendering(ent, kRenderFxNone, 10, 10, 255, kRenderTransColor, 100)
	set_pev(ent, pev_nextthink, get_gametime() + 0.1)
	client_cmd(id, "spk %s",other_sound[0])
	return PLUGIN_CONTINUE
}

public box_delete_all(id) {
	static fb, bool:is_del; is_del = false
	fb = engfunc(EngFunc_FindEntityByString, -1, "classname", "box_breakable")
	while(fb > 0) {
		if(pev_valid(fb)) {
			static id
			id = get_mover_box(fb)
			if(is_normal_index(id)) {
				set_moving_box(id, 0)
				IsMove[id] = false
			}
			id = get_thrower_box(fb)
			if(is_normal_index(id)) 
				set_throwing_box(id, 0)
			is_del = true
			engfunc(EngFunc_RemoveEntity, fb)
		}
		fb = engfunc(EngFunc_FindEntityByString, fb, "classname", "box_breakable")
	}
	if(is_del) {
		client_print(id, print_chat, "[box] all boxes were deleted !")
		client_cmd(id, "spk %s",other_sound[0])
	}
	else {
		client_print(id, print_chat, "[box] not a one box is not deleted !")
		client_cmd(id, "spk %s",other_sound[2])
	}
	return PLUGIN_CONTINUE
}

public box_delete_all_saved(id) {
	static fb, bool:is_del; is_del = false
	fb = engfunc(EngFunc_FindEntityByString, -1, "classname", "box_breakable")
	while(fb > 0) {
		if(pev_valid(fb) && is_saved_box(fb)) {
			static id
			id = get_mover_box(fb)
			if(is_normal_index(id)) {
				set_moving_box(id, 0)
				IsMove[id] = false
			}
			id = get_thrower_box(fb)
			if(is_normal_index(id)) 
				set_throwing_box(id, 0)
			is_del = true
			engfunc(EngFunc_RemoveEntity, fb)
		}
		fb = engfunc(EngFunc_FindEntityByString, fb, "classname", "box_breakable")
	}
	if(is_del) {
		client_print(id, print_chat, "[box] all boxes saved were deleted !")
		client_cmd(id, "spk %s",other_sound[0])
	}
	else {
		client_print(id, print_chat, "[box] not a one box saved is not deleted !")
		client_cmd(id, "spk %s",other_sound[2])
	}
	return PLUGIN_CONTINUE
}

public box_create_exec(id) {
	static cmd1[32], cmd2[32], cmd3[32], cmd4[7], mark, Float:fOrigin[3], ent
	read_argv(1, cmd1, 31)
	read_argv(2, cmd2, 31)
	read_argv(3, cmd3, 31)
	read_argv(4, cmd4, 6)
	fOrigin[0] = str_to_float(cmd1)
	fOrigin[1] = str_to_float(cmd2)
	fOrigin[2] = str_to_float(cmd3)
	mark = str_to_num(cmd4)
	ent = create_box(fOrigin)
	if(ent != 0) {
		if(mark == 4444)
			mark_save_box(ent)
		set_pev(ent, pev_nextthink, get_gametime() + 0.1)
	}
	return PLUGIN_CONTINUE
}

public box_save_mapfile(id) {
	if(id != 1) 
		return PLUGIN_CONTINUE
	if(file_exists(mapfile)) 
		delete_file(mapfile)
	write_file(mapfile, "// Do not change nor what^n")
	static fb, bool:is_save; is_save = false
	fb = engfunc(EngFunc_FindEntityByString, -1, "classname", "box_breakable")
	while(fb > 0) {
		if(pev_valid(fb)) {
			is_save = true
			write_mapfile(fb)
		}
		fb = engfunc(EngFunc_FindEntityByString, fb, "classname", "box_breakable")
	}
	if(is_save) {
		client_print(id, print_chat, "[box] all boxes are preserved in map file !")
		client_cmd(id, "spk %s",other_sound[0])
	}
	else {
		client_print(id, print_chat, "[box] not a one box is not preserved !")
		client_cmd(id, "spk %s",other_sound[2])
	}
	return PLUGIN_CONTINUE
}

public box_load_mapfile(id) {
	if(id != 1) 
		return PLUGIN_CONTINUE
	if(file_exists(mapfile)) {
		server_cmd("exec %s",mapfile)
		client_print(id, print_chat, "[box] file of the map was loaded !")
		client_cmd(id, "spk %s",other_sound[0])
	}
	else {
		client_print(id, print_chat, "[box] impossible load, file of the map does not exist !")
		client_cmd(id, "spk %s",other_sound[2])
	}
	return PLUGIN_CONTINUE
}

public box_reload_mapfile(id) {
	if(id != 1) 
		return PLUGIN_CONTINUE
	if(!file_exists(mapfile)) {
		client_print(id, print_chat, "[box] impossible reload, file of the map does not exist !")
		client_cmd(id, "spk %s",other_sound[2])
		return PLUGIN_CONTINUE
	}
	static fb
	fb = engfunc(EngFunc_FindEntityByString, -1, "classname", "box_breakable")
	while(fb > 0) {
		if(pev_valid(fb) && is_saved_box(fb)) {
			static id
			id = get_mover_box(fb)
			if(is_normal_index(id)) {
				set_moving_box(id, 0)
				IsMove[id] = false
			}
			id = get_thrower_box(fb)
			if(is_normal_index(id)) 
				set_throwing_box(id, 0)
			engfunc(EngFunc_RemoveEntity, fb)
		}
		fb = engfunc(EngFunc_FindEntityByString, fb, "classname", "box_breakable")
	}
	server_cmd("exec %s",mapfile)
	client_print(id, print_chat, "[box] file of the map was reloaded !")
	client_cmd(id, "spk %s",other_sound[0])
	return PLUGIN_CONTINUE
}

public box_delete_mapfile(id) {
	if(id != 1) 
		return PLUGIN_CONTINUE
	if(file_exists(mapfile)) {
		delete_file(mapfile)
		client_print(id, print_chat, "[box] file of the map was deleted !")
		client_cmd(id, "spk %s",other_sound[0])
	}
	else {
		client_print(id, print_chat, "[box] impossible delete, file of the map does not exist !")
		client_cmd(id, "spk %s",other_sound[2])
	}
	return PLUGIN_CONTINUE
}

public box_delete_current(id) {
	if(id != 1) 
		return PLUGIN_CONTINUE
	static ent
	ent = fm_get_aiment_dist(id, 9999.0)
	if(is_entity_box_breakable(ent)) {
		static id
		id = get_mover_box(ent)
		if(is_normal_index(id)) {
			set_moving_box(id, 0)
			IsMove[id] = false
		}
		id = get_thrower_box(ent)
		if(is_normal_index(id)) 
			set_throwing_box(id, 0)
		engfunc(EngFunc_RemoveEntity, ent)
		client_print(id, print_chat, "[box] current box deleted !")
		client_cmd(id, "spk %s",other_sound[0])
	}
	else {
		client_print(id, print_chat, "[box] impossible delete box !")
		client_cmd(id, "spk %s",other_sound[2])
	}
	return PLUGIN_CONTINUE
}
	
stock write_mapfile(ent) {
	mark_save_box(ent)
	static Float:fOrigin[3], fstr[128]
	pev(ent, pev_origin, fOrigin)
	format(fstr, 127, "box_create_exec %f %f %f 4444",fOrigin[0],fOrigin[1],fOrigin[2])
	write_file(mapfile, fstr)
	return 1
}

stock create_box(Float:fEntOrigin[3]) {
	static ent
	ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, "info_target"))
	if(!pev_valid(ent)) 
		return 0
	set_pev(ent, pev_classname, "box_breakable")
	set_pev(ent, pev_origin, fEntOrigin)
	set_pev(ent, pev_solid, SOLID_SLIDEBOX)
	set_pev(ent, pev_movetype, MOVETYPE_PUSHSTEP)
	set_pev(ent, pev_health, get_cvar_float("box_health"))
	set_pev(ent, pev_takedamage, DAMAGE_YES)
	engfunc(EngFunc_SetModel, ent, "models/box.mdl")
	engfunc(EngFunc_SetSize, ent, fBoxMins, fBoxMaxs)
	set_pev(ent, pev_body, random_num(0, 2))
	return ent
}

stock box_push_from_attacker(ent, idother, Float:multiplier) {
	static Float:fVector[3], Float:fEntVelocity[3]
	pev(idother, pev_v_angle, fVector)
	angle_vector(fVector, ANGLEVECTOR_FORWARD, fVector)
	xs_vec_mul_scalar(fVector, multiplier * 3, fVector)
	pev(ent, pev_velocity, fEntVelocity)
	xs_vec_add(fEntVelocity, fVector, fVector)
	set_pev(ent, pev_velocity, fVector)
	return 1
}

stock box_push_from_grenade(ent, idother, Float:multiplier) {
	static Float:v1[3], Float:v2[3], Float:v3[3]
	pev(ent, pev_origin, v1)
	pev(idother, pev_origin, v2)
	xs_vec_sub(v1, v2, v3)
	xs_vec_normalize(v3, v3)
	xs_vec_mul_scalar(v3, 8.0 * multiplier, v3)
	pev(ent, pev_velocity, v1)
	pev(idother, pev_velocity, v2)
	xs_vec_add(v1, v2, v1)
	xs_vec_add(v1, v3, v1)
	set_pev(ent, pev_velocity, v1)
	return 1
}

stock get_throw_velocity(index, Float:fRetVelocity[3]) {
	pev(index, pev_v_angle, fRetVelocity)
	angle_vector(fRetVelocity, ANGLEVECTOR_FORWARD, fRetVelocity)
	xs_vec_mul_scalar(fRetVelocity, 2000.0, fRetVelocity)
	return 1
}

stock bool:is_damaging_entity(ent) {
	if(pev_valid(ent)) {
		static Float:health, Float:takedamage
		pev(ent, pev_health, health)
		pev(ent, pev_takedamage, takedamage)
		if(health > 0.0 && takedamage > 0.0) 
			return true
	}
	return false
}

stock bool:is_entity_box_breakable(ent) {
	if(pev_valid(ent)) {
		static classname[32]
		pev(ent, pev_classname, classname, 31)
		if(equal(classname, "box_breakable")) 
			return true
	}
	return false
}

stock bool:is_inflictor_grenade(ent) {
	if(pev_valid(ent)) {
		static classname[32]
		pev(ent, pev_classname, classname, 31)
		if(equal(classname, "grenade")) 
			return true
	}
	return false
}

stock bool:is_normal_index(index) {
	if(index > 0 && index < 33) 
		return true
	return false
}

stock create_dust(Float:fOrigin[3]) {
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_SPRITE)
	engfunc(EngFunc_WriteCoord, fOrigin[0]) // x
	engfunc(EngFunc_WriteCoord, fOrigin[1]) // y
	engfunc(EngFunc_WriteCoord, fOrigin[2] + fBoxCenterZ) // z
	write_short(DustSprite) // sprite
	write_byte(10) // scale
	write_byte(50) // brightness
	message_end()
}

stock create_breakmodel(Float:fOrigin[3]) {
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(TE_BREAKMODEL)
	engfunc(EngFunc_WriteCoord, fOrigin[0]) // x
	engfunc(EngFunc_WriteCoord, fOrigin[1]) // y
	engfunc(EngFunc_WriteCoord, fOrigin[2] + fBoxCenterZ) // z
	write_coord(16) // size x
	write_coord(16) // size y
	write_coord(16) // size z
	write_coord(random_num(-50,50)) // velocity x
	write_coord(random_num(-50,50)) // velocity y
	write_coord(25) // velocity z
	write_byte(10) // random velocity
	write_short(GibsModel) // model
	write_byte(20) // count
	write_byte(120) // life
	write_byte(0x03) // flags
	message_end()
	return 1
}

stock get_mover_box(ent) {
	return pev(ent, pev_iuser1)
}

stock set_mover_box(ent, index) {
	set_pev(ent, pev_iuser1, index)
	return 1
}

stock get_moving_box(index) {
	return EntMove[index]
}

stock set_moving_box(index, ent) {
	EntMove[index] = ent
	return 1
}

stock get_thrower_box(ent) {
	return pev(ent, pev_iuser2)
}

stock set_thrower_box(ent, index) {
	set_pev(ent, pev_iuser2, index)
	return 1
}

stock get_throwing_box(index) {
	return EntThrow[index]
}

stock set_throwing_box(index, ent) {
	EntThrow[index] = ent
	return 1
}

stock bool:is_saved_box(ent) {
	if(pev(ent, pev_iuser3) == 4444) 
		return true
	return false
}

stock mark_save_box(ent) {
	set_pev(ent, pev_iuser3, 4444)
	return 1
}

stock fm_get_aiment_dist(index, Float:fDistance, entignore = 0, monstersignore = 0) {
	static Float:fStart[3], Float:fViewOfs[3], trace, hit
	pev(index, pev_origin, fStart)
	pev(index, pev_view_ofs, fViewOfs)
	xs_vec_add(fStart, fViewOfs, fStart)
	static Float:fDest[3]
	pev(index, pev_v_angle, fDest)
	engfunc(EngFunc_MakeVectors, fDest)
	global_get(glb_v_forward, fDest)
	xs_vec_mul_scalar(fDest, fDistance, fDest)
	xs_vec_add(fStart, fDest, fDest)
	if(entignore > 0) 
		engfunc(EngFunc_TraceLine, fStart, fDest, monstersignore == 1 ? 1:0, entignore, trace)
	else 
		engfunc(EngFunc_TraceLine, fStart, fDest, monstersignore == 1 ? 1:0, index, trace)
	hit = get_tr2(trace, TR_pHit)
	free_tr2(trace)
	return hit
}

stock fm_get_aimorigin_dist(index, Float:fDistance, Float:fRetOrigin[3], entignore = 0, monstersignore = 0) {
	static Float:fStart[3], Float:fViewOfs[3], trace
	pev(index, pev_origin, fStart)
	pev(index, pev_view_ofs, fViewOfs)
	xs_vec_add(fStart, fViewOfs, fStart)
	static Float:fDest[3]
	pev(index, pev_v_angle, fDest)
	engfunc(EngFunc_MakeVectors, fDest)
	global_get(glb_v_forward, fDest)
	xs_vec_mul_scalar(fDest, fDistance, fDest)
	xs_vec_add(fStart, fDest, fDest)
	if(pev_valid(entignore)) 
		engfunc(EngFunc_TraceLine, fStart, fDest, monstersignore == 1 ? 1:0, entignore, trace)
	else 
		engfunc(EngFunc_TraceLine, fStart, fDest, monstersignore == 1 ? 1:0, index, trace)
	get_tr2(trace, TR_vecEndPos, fRetOrigin)
	free_tr2(trace)
	return 1
}

stock Float:fm_distance_to_floor(ent, entignore = 0, monstersignore = 0) {
	static Float:fStart[3], Float:fDest[3], Float:fEnd[3], trace, Float:ret
	pev(ent, pev_origin, fStart)
	fDest[0] = fStart[0]
	fDest[1] = fStart[1]
	fDest[2] = -8191.0
	if(pev_valid(entignore)) 
		engfunc(EngFunc_TraceLine, fStart, fDest, monstersignore == 1 ? 1:0, entignore, trace)
	else 
		engfunc(EngFunc_TraceLine, fStart, fDest, monstersignore == 1 ? 1:0, ent, trace)
	get_tr2(trace, TR_vecEndPos, fEnd)
	free_tr2(trace)
	pev(ent, pev_absmin, fStart)
	ret = fStart[2] - fEnd[2]
	return ret > 0.0 ? ret:0.0
}

stock fm_set_rendering(entity, fx = kRenderFxNone, r = 255, g = 255, b = 255, render = kRenderNormal, amount = 16) {
	static Float:RenderColor[3]
	RenderColor[0] = float(r)
	RenderColor[1] = float(g)
	RenderColor[2] = float(b)
	set_pev(entity, pev_renderfx, fx)
	set_pev(entity, pev_rendercolor, RenderColor)
	set_pev(entity, pev_rendermode, render)
	set_pev(entity, pev_renderamt, float(amount))
	return 1
}
