/*================================================================================
	
	-------------------------------------------
	-*- [ZP] Extra Item: Critical Strike v. 1.4 | by Re.Act!ve -*-
	-------------------------------------------

	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	This Extra Item establishes on your weapon critical shots and deadly shots. All is adjusted by cvars

	~~~~~~~~~~~~~~~
	- Credits -
	~~~~~~~~~~~~~~~
	Re.Act!ve 			This Build Plugin

	~~~~~~~~~~~~~~~
	- Changelog -
	~~~~~~~~~~~~~~~
	v. 1.0	 - First Plugin Released, version released
	v. 1.1 - Added Sounds of critical strike, fixed bugs on crities
	v. 1.2 - Added Kill Strike, and her cvars. 
	v. 1.3 - Fixed small bug
	v. 1.4 - Added Sound & Effects to Kill Strike, new cvars.
================================================================================*/
#include <amxmodx>
#include <hamsandwich>
#include <zombieplague>

#define PLUGIN "[ZP] Extra Item: Critical Strike"
#define VERSION "1.4"
#define AUTHOR "Re.Act!ve"
#pragma tabsize 0

new SayText
new g_chance, g_screen, g_screen_time, g_kill_strike, g_item_strike, Float:g_critical
new g_ScreenFade, g_kill_chance, g_sprite, g_kill
new bool:g_has_item[33], g_killed[33], g_weapon[33]
new const g_item_name[] = { "Critical Strike" }; 	// Critical Strike name
new const g_item_cost = 20 ; 	// Critical Strike item cost
new Float:g_min_multiple = 2.7	// Min Crities
new Float:g_max_multiple = 3.0	// Max Crities

new const sound_fvox_buy[] = { "fvox/weapon_pickup.wav" } 	// Sound to Buying Item
new const sound_critical[] = { "misc/zp_combowhore.wav" } 	// Sound to Crirtical Shot
new const sound_kill[ 2 ][] = { "misc/zp_ludicrouskill.wav",  "misc/zp_monsterkill.wav" } 	// Sound to Kill Shot

public plugin_precache()
{
	precache_sound(sound_critical)
	precache_sound(sound_fvox_buy)
    	static n
    	for(n = 1; n < sizeof sound_kill; n++)
        precache_sound( sound_kill[n] )
	g_sprite = precache_model("sprites/lgtning.spr")
}

public plugin_init()
{
	g_chance = register_cvar("zp_critical_chance", "5")			// Procent Chance Critical Strike (Example: 13 = 13%)
	g_screen = register_cvar("zp_critical_screen", "1")			// Blood Screen for victim < 1 | 0 >
	g_screen_time = register_cvar("zp_critical_screentime", "1.5")	// Screen is time seconds
	g_kill_strike = register_cvar("zp_kill_strike", "1")		 		// Kill Strike (We are kill zombie) < 1 | 0 >
	g_kill_chance = register_cvar("zp_kill_chance", "1")			// Kill Strike chance, if cvar ON (Example: 2 = 2%)
	register_plugin(PLUGIN, VERSION, AUTHOR)
	g_item_strike = zp_register_extra_item(g_item_name, g_item_cost, ZP_TEAM_HUMAN)
	SayText = get_user_msgid("SayText")
	register_event("HLTV", "round_start", "a", "1=0", "2=0")
	register_event("DeathMsg", "Death_attacker", "a")
	register_event("CurWeapon","Critical_Strike","be", "1=1", "3>0")
	register_event("CurWeapon","trace_line","be", "1=1", "3>0")
	RegisterHam(Ham_TakeDamage, "player", "FwdTakeDamage")
	g_ScreenFade = get_user_msgid( "ScreenFade" )	
}

public Death_attacker()
{
	new id = read_data(2)
	g_has_item[id] = false;
	g_killed[id] = false;
	g_weapon[id] = false;
}

public zp_extra_item_selected(player, itemid)
{
	if ( (itemid == g_item_strike) && !zp_get_user_zombie(player) && !zp_get_user_nemesis( player ))
	{		
		g_has_item[player] = true
		g_killed[player] = false;
		g_weapon[player] = false;
		ChatColor(player, "!g[ZP] !yWith in your gun installed !tCritical Strike")		
		emit_sound(player, CHAN_STREAM, sound_fvox_buy, 1.0, ATTN_NORM, 0, PITCH_NORM)
	}
	else
	{
		g_has_item[player] = false
	}
}

public FwdTakeDamage(victim, inflictor, attacker, Float:damage, damage_bits)
{ 
	if (g_has_item[attacker] && (attacker != victim) && is_user_alive(attacker) ) 
	{ 
		if(g_killed[attacker])
		{
			emit_sound(attacker, CHAN_STREAM, sound_kill [random_num(1, 2)], 1.0, ATTN_NORM, 0, PITCH_HIGH )
			client_print(attacker, print_center, "[Killer Shot]")
   			SetHamParamFloat(4, damage + 9999);
			g_killed[attacker] = false;
		}
		if(g_weapon[attacker])
		{
			if(get_pcvar_num(g_screen) == 1)
			{
				client_print(victim, print_center, "Critical Strike")
				Screen_victim(victim);
			}
			emit_sound(attacker, CHAN_STREAM, sound_critical, 1.0, ATTN_NORM, 0, PITCH_HIGH )
			g_weapon[attacker] = false;
			g_critical = random_float(g_min_multiple, g_max_multiple);	
			new Float:crits; crits = damage * g_critical;
			SetHamParamFloat(4, crits );
			client_print(attacker, print_center, "[Critical Strike: %.f damage]", crits)
		}	
	}
}  

Screen_victim(id)
{
	message_begin(MSG_ONE_UNRELIABLE, g_ScreenFade, _, id) 
       	write_short(1<<12) // duration 
        write_short(get_pcvar_num(g_screen_time)) // hold time 
	write_short(0x0000) // fade type 
	write_byte(200) // red 
	write_byte(0) // green 
	write_byte(0) // blue 
	write_byte(200) // alpha 
	message_end() 
}
public Critical_Strike(id)
{
	new random_s[32]; random_s[id] = random_num(1, 100);
	if (g_has_item[id] && is_user_alive(id) && !zp_get_user_zombie(id) && !zp_get_user_nemesis(id)) 
	{ 
		if( (random_s[id] <= get_pcvar_num(g_kill_chance)) && get_pcvar_num(g_kill_strike) )
		{
			g_killed[id] = true;
			g_kill = 1;
		}

		if( random_s[id] < get_pcvar_num(g_chance) )
		{
			g_weapon[id] = true;
		}
	}
}

public trace_line(id)
{
	// new clip, Ammo, Weapons[32]
	// new Weapon	
	// Weapon = get_user_weapon(id, clip , Ammo)
	// get_weaponname(Weapon, Weapons, 31)

	if(g_killed[id] && g_has_item[id] && (g_kill == 1))
	{
	new vec1[3], vec2[3]
	get_user_origin(id, vec1, 1) 	// origin; your camera point.
	get_user_origin(id, vec2, 4) 	// termina; where your bullet goes (4 is cs-only)			
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte (0)     //TE_BEAMENTPOINTS 0
	write_coord(vec1[0])
	write_coord(vec1[1])
	write_coord(vec1[2])
	write_coord(vec2[0])
	write_coord(vec2[1])
	write_coord(vec2[2])
	write_short( g_sprite )
	write_byte(0) // framestart
	write_byte(5) // framerate
	write_byte(2) // life
	write_byte(10) // width
	write_byte(0) // noise
	write_byte( 255 )     // r, g, b
	write_byte( 0 )       // r, g, b
	write_byte( 0 )       // r, g, b
	write_byte(200) // brightness
	write_byte(150) // speed
	message_end()
	g_killed[id] = false;
	g_kill = 0;
	}
}

stock ChatColor(const id, const input[], any:...)
{
	new count = 1, players[32]
	static msg[191]
	vformat(msg, 190, input, 3)
	
	replace_all(msg, 190, "!g", "^4") // Green Color
	replace_all(msg, 190, "!y", "^1") // Default Color
	replace_all(msg, 190, "!t", "^3") // Team Color
	replace_all(msg, 190, "!t2", "^0") // Team2 Color
	
	if (id) players[0] = id; else get_players(players, count, "ch")
	{
		for (new i = 0; i < count; i++)
		{
			if (is_user_connected(players[i]))
			{
				message_begin(MSG_ONE_UNRELIABLE, SayText, _, players[i])
				write_byte(players[i]);
				write_string(msg);
				message_end();
			}
		}
	}
}

public round_start(id)
{
	for (new id; id <= 32; id++) 
	{
		g_has_item[id] = false;
		g_killed[id] = false;
		g_weapon[id] = false;
	}
}