#include <amxmodx>
#include <amxmisc>
#include <fakemeta>

#define PLUGIN "Bomb Defuse Predictions"
#define VERSION "1.0"
#define AUTHOR "Starsailor"

#define TIME_WITH_DEFUSE 5
#define TIME_WITHOUT_DEFUSE 10

#define TASK_TIMER 4623

new iC4TimerPointer, iC4Timer
new pEnabled, bIsEnabled

public plugin_init()
{
	new szPluginName[32]
	
	if(engfunc(EngFunc_FindEntityByString, -1, "classname","func_bomb_target") || engfunc(EngFunc_FindEntityByString, -1, "classname","info_bomb_target"))
	{
		register_event("BarTime", "event_defusing", "be", "1=5", "1=10")
		
		register_logevent("logevent_bomb_planted", 3, "2=Planted_The_Bomb")
		register_logevent("logevent_bomb_defused", 3, "2=Defused_The_Bomb")
		
		register_event("HLTV","event_new_round","a","1=0","2=0")
		
		iC4TimerPointer = get_cvar_pointer("mp_c4timer")
		
		pEnabled = register_cvar("bdp_enabled","1")
		register_cvar("bdp_version",VERSION,FCVAR_SERVER|FCVAR_SPONLY)
		
		register_message(get_user_msgid("SayText"), "MessageSayText")
		
		format(szPluginName,charsmax(szPluginName),"%s (On)",PLUGIN)
		
		register_plugin(szPluginName,VERSION,AUTHOR)
	}
	else
	{
		format(szPluginName,charsmax(szPluginName),"%s (Off)",PLUGIN)
		
		register_plugin(szPluginName, VERSION, AUTHOR)
		
		set_fail_state("Invalid Map")
	}
	
	
}

public event_defusing(id)
{
	if(!bIsEnabled)
	{
		return
	}
	
	if(get_pdata_int(id, 193) & (1<<16)) //Has defuser kit
	{
		if(iC4Timer > TIME_WITH_DEFUSE)
		{
			client_print(id,print_center,"Тише, у вас достаточно времени, чтобы обезвредить бомбу")
		}
		else
		{
			client_print(id,print_center,"Беги! У тебя не достаточно времени, чтобы обезвредить бомбу!")
		}
	}
	
	else
	{
		if(iC4Timer > TIME_WITHOUT_DEFUSE)
		{
			client_print(id,print_center,"Тише, у вас достаточно времени, чтобы обезвредить бомбу")
		}
		else
		{
			client_print(id,print_center,"Беги! У тебя не достаточно времени, чтобы обезвредить бомбу!")
		}
	}
}

public event_new_round()
{
	if((bIsEnabled = get_pcvar_num(pEnabled)) == 1)
	{
		iC4Timer = 0
	}
}

public logevent_bomb_planted()
{
	if(bIsEnabled)
	{
		iC4Timer = get_pcvar_num(iC4TimerPointer)
		set_task(1.0, "ShowTimer",TASK_TIMER, _, _, "b")
	}
}

public logevent_bomb_defused()
{
	if(task_exists(TASK_TIMER))
	{
		remove_task(TASK_TIMER)
	}
}

public ShowTimer(Taskid)
{
	--iC4Timer
	
	if(iC4Timer <= 0)
	{
		remove_task(Taskid)
		iC4Timer = 0
	}
	
}

public MessageSayText(msg_id, msg_dest, receiver)
{
	new szInfo[64] 
	
	get_msg_arg_string(2, szInfo, 63) 
	
	if(!bIsEnabled)
	{
		return PLUGIN_CONTINUE
	}
	
	if(equali(szInfo, "#Defusing_Bomb_Without_Defuse_Kit") || equali(szInfo, "#Defusing_Bomb_With_Defuse_Kit")) 
	{
		return PLUGIN_HANDLED
	}
	
	return PLUGIN_CONTINUE
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang3082\\ f0\\ fs16 \n\\ par }
*/
