/* 
Plugin: SpawnProtection
Version: 1.5

Credits:
-- PykaB
-- Hafner
-- Fedcomp
-- xPaw
-- PomanoB
*/

#include <amxmodx>
#include <fakemeta_util>
#include <hamsandwich>
#include <cstrike>

#define PLUGIN "SpawnProtection"
#define VERSION "1.5"
#define AUTHOR "a.aqua"

new CvarSPTime, CvarSPMsg, CvarSPEffect, CvarSPNA
new bool:g_bDisable[33]
new HamHook: fwd_TraceAttack

public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_dictionary("SpawnProtection.txt")
	CvarSPTime	= register_cvar ( "sp_time", "10.0")
	CvarSPMsg	= register_cvar ( "sp_msgshow", "1")
	CvarSPEffect	= register_cvar ( "sp_msgeffect", "0")
	CvarSPNA	= register_cvar	( "sp_noattack", "1")

	RegisterHam(Ham_Spawn, "player", "SpOn", 1)
	fwd_TraceAttack = RegisterHam(Ham_TraceAttack, "player", "Forward_TraceAttack")
	DisableHamForward (fwd_TraceAttack)

	register_cvar ( "sp_version", VERSION, FCVAR_SERVER|FCVAR_SPONLY)
}

public SpOn(id) {
	new Float:iTime = get_pcvar_float(CvarSPTime)
	new iMsg = get_pcvar_num(CvarSPMsg)
	new iTeam = _:cs_get_user_team(id)
	new iEffect = clamp(get_pcvar_num(CvarSPEffect), 0, 2)

	new g_colors[4][3] = {
		{0, 0, 0},
		{255, 0, 0},
		{0, 0, 255},
		{0, 0, 0}
	}


	if (is_user_alive(id)) {
		EnableHamForward(fwd_TraceAttack)
		if (iMsg) {
			set_hudmessage(255, 1, 1, -1.0, -1.0, iEffect, 6.0, iTime, 0.1, 0.2, -1)
			show_hudmessage(id, "%L", id, "SP_SHWMSG", floatround(get_pcvar_float(CvarSPTime)))
		}

		fm_set_rendering(id, kRenderFxGlowShell, g_colors[iTeam][0], g_colors[iTeam][1], g_colors[iTeam][2], kRenderNormal, 10)
		set_task(iTime, "SpOff", id)
		g_bDisable[id] = true
	}
}

public SpOff(id) {
	DisableHamForward(fwd_TraceAttack)
	g_bDisable[id] = false

	fm_set_rendering(id)
}

public Forward_TraceAttack(id, attacker, Float:dmg, Float:dir[3], tr, dmgbit) {
	new iNoAttack = get_pcvar_num(CvarSPNA)
	if(g_bDisable[attacker] && iNoAttack || g_bDisable[id] && id != attacker) {
			if(get_user_weapon(attacker) == CSW_KNIFE) {
				return HAM_IGNORED
			}
			return HAM_SUPERCEDE
	}
	
	return HAM_IGNORED
}

/* Privet Mama, Papa, Babushka ii Kot! :)  BioShock 2 */