#include <amxmodx>  
#include <amxmisc>  
#include <fun>  

#define SPEED 400.0 // Note: increasing this is likely to have no effect unless you alter server & clients cvars
#define RED 180
#define GREEN 240
#define BLUE 140

new bool:g_adrenaline[33]
new g_cweapon[33]

public plugin_init() 
{  
	register_plugin("adrenaline boost", "1.0", "watch")

	register_event("HLTV" , "new_round" , "a" , "1=0" , "2=0")
	register_event("Damage", "damage_event", "b", "2!0")
	register_event("CurWeapon","weapon_event","be","1=1")
	register_event("DeathMsg", "death_event", "a")

	register_cvar("amx_adrenaline","1")
	register_cvar("amx_adrenaline_health","5")
}

// check if the player has low enough health to gain an adrenaline boost
public damage_event(id)
{
	if (!get_cvar_num("amx_adrenaline"))
		return PLUGIN_CONTINUE

	if (g_adrenaline[id])
		return PLUGIN_CONTINUE
	
	if (!is_user_alive(id))
		return PLUGIN_CONTINUE

	if (get_user_health(id) <= get_cvar_num("amx_adrenaline_health")) 
	{
		set_user_maxspeed(id, SPEED)
		set_user_rendering(id, kRenderFxGlowShell, RED, GREEN, BLUE, kRenderNormal, 0)

		message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0,0,0}, id)
		write_short(~0)
		write_short(~0)
		write_short(0x0004) // stay faded
		write_byte(RED)
		write_byte(GREEN)
		write_byte(BLUE)
		write_byte(100)
		message_end()

		client_cmd(id,"spk fvox/adrenaline_shot.wav")
		g_adrenaline[id]=true
	}
	return PLUGIN_CONTINUE
}

// remove screenfade as they are in spec now
public death_event()
{
	if (!get_cvar_num("amx_adrenaline"))
		return PLUGIN_CONTINUE

	new id = read_data(2)
	if (g_adrenaline[id])
	{
		message_begin(MSG_ONE, get_user_msgid("ScreenFade"), {0,0,0}, id)
		write_short(1<<10)
		write_short(1<<10)
		write_short(0x0000) // fade out
		write_byte(RED)
		write_byte(GREEN)
		write_byte(BLUE)
		write_byte(100)
		message_end()
	}
	return PLUGIN_CONTINUE
}

// reset adrenaline
public new_round()
{
	if (!get_cvar_num("amx_adrenaline"))
		return PLUGIN_CONTINUE

	new players[32], num, player
	get_players(players, num)
	for (new i=0; i<num; i++)
	{
		player = players[i]

		if(!is_user_connected(player))
			continue

		if(g_adrenaline[player])
		{
			set_user_maxspeed(player, 0.0)
			set_user_rendering(player, kRenderFxGlowShell, 0, 0, 0, kRenderNormal, 0)
			g_adrenaline[player] = false
		}
	}
	return PLUGIN_CONTINUE
}

// ensure speed doesnt alter when they change weapon
public weapon_event(id) 
{
	new weaponid = read_data(2)
	if (g_cweapon[id] != weaponid) 
	{
		if (!get_cvar_num("amx_adrenaline"))
			return PLUGIN_CONTINUE

		if(g_adrenaline[id]) 
			set_user_maxspeed(id, SPEED)
	}
	return PLUGIN_CONTINUE
}
